/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_10.extensions;

import io.fabric8.kubernetes.api.builder.v4_10.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_10.extensions.ReplicaSetSpec;
import io.fabric8.kubernetes.api.model.v4_10.extensions.ReplicaSetSpecFluent;
import io.fabric8.kubernetes.api.model.v4_10.extensions.ReplicaSetSpecFluentImpl;

public class ReplicaSetSpecBuilder
extends ReplicaSetSpecFluentImpl<ReplicaSetSpecBuilder>
implements VisitableBuilder<ReplicaSetSpec, ReplicaSetSpecBuilder> {
    ReplicaSetSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ReplicaSetSpecBuilder() {
        this(true);
    }

    public ReplicaSetSpecBuilder(Boolean validationEnabled) {
        this(new ReplicaSetSpec(), validationEnabled);
    }

    public ReplicaSetSpecBuilder(ReplicaSetSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ReplicaSetSpecBuilder(ReplicaSetSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ReplicaSetSpec(), validationEnabled);
    }

    public ReplicaSetSpecBuilder(ReplicaSetSpecFluent<?> fluent, ReplicaSetSpec instance) {
        this(fluent, instance, true);
    }

    public ReplicaSetSpecBuilder(ReplicaSetSpecFluent<?> fluent, ReplicaSetSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withMinReadySeconds(instance.getMinReadySeconds());
        fluent.withReplicas(instance.getReplicas());
        fluent.withSelector(instance.getSelector());
        fluent.withTemplate(instance.getTemplate());
        this.validationEnabled = validationEnabled;
    }

    public ReplicaSetSpecBuilder(ReplicaSetSpec instance) {
        this(instance, (Boolean)true);
    }

    public ReplicaSetSpecBuilder(ReplicaSetSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withMinReadySeconds(instance.getMinReadySeconds());
        this.withReplicas(instance.getReplicas());
        this.withSelector(instance.getSelector());
        this.withTemplate(instance.getTemplate());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ReplicaSetSpec build() {
        ReplicaSetSpec buildable = new ReplicaSetSpec(this.fluent.getMinReadySeconds(), this.fluent.getReplicas(), this.fluent.getSelector(), this.fluent.getTemplate());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ReplicaSetSpecBuilder that = (ReplicaSetSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

