/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_10;

import io.fabric8.kubernetes.api.builder.v4_10.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_10.PodExecOptions;
import io.fabric8.kubernetes.api.model.v4_10.PodExecOptionsFluent;
import io.fabric8.kubernetes.api.model.v4_10.PodExecOptionsFluentImpl;

public class PodExecOptionsBuilder
extends PodExecOptionsFluentImpl<PodExecOptionsBuilder>
implements VisitableBuilder<PodExecOptions, PodExecOptionsBuilder> {
    PodExecOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public PodExecOptionsBuilder() {
        this(true);
    }

    public PodExecOptionsBuilder(Boolean validationEnabled) {
        this(new PodExecOptions(), validationEnabled);
    }

    public PodExecOptionsBuilder(PodExecOptionsFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public PodExecOptionsBuilder(PodExecOptionsFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new PodExecOptions(), validationEnabled);
    }

    public PodExecOptionsBuilder(PodExecOptionsFluent<?> fluent, PodExecOptions instance) {
        this(fluent, instance, true);
    }

    public PodExecOptionsBuilder(PodExecOptionsFluent<?> fluent, PodExecOptions instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withCommand(instance.getCommand());
        fluent.withContainer(instance.getContainer());
        fluent.withKind(instance.getKind());
        fluent.withStderr(instance.getStderr());
        fluent.withStdin(instance.getStdin());
        fluent.withStdout(instance.getStdout());
        fluent.withTty(instance.getTty());
        this.validationEnabled = validationEnabled;
    }

    public PodExecOptionsBuilder(PodExecOptions instance) {
        this(instance, (Boolean)true);
    }

    public PodExecOptionsBuilder(PodExecOptions instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withCommand(instance.getCommand());
        this.withContainer(instance.getContainer());
        this.withKind(instance.getKind());
        this.withStderr(instance.getStderr());
        this.withStdin(instance.getStdin());
        this.withStdout(instance.getStdout());
        this.withTty(instance.getTty());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public PodExecOptions build() {
        PodExecOptions buildable = new PodExecOptions(this.fluent.getApiVersion(), this.fluent.getCommand(), this.fluent.getContainer(), this.fluent.getKind(), this.fluent.isStderr(), this.fluent.isStdin(), this.fluent.isStdout(), this.fluent.isTty());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodExecOptionsBuilder that = (PodExecOptionsBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

