/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal.apps.v1;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentList;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent;
import io.fabric8.kubernetes.api.model.apps.DoneableDeployment;
import io.fabric8.kubernetes.api.model.apps.DoneableReplicaSet;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetList;
import io.fabric8.kubernetes.api.model.extensions.DeploymentRollback;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ImageEditReplacePatchable;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.TimeoutImageEditReplacePatchable;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.dsl.internal.RollingOperationContext;
import io.fabric8.kubernetes.client.dsl.internal.apps.v1.DeploymentRollingUpdater;
import io.fabric8.kubernetes.client.dsl.internal.apps.v1.ReplicaSetOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.apps.v1.RollableScalableResourceOperation;
import io.fabric8.kubernetes.client.dsl.internal.apps.v1.RollingUpdater;
import io.fabric8.kubernetes.client.utils.KubernetesResourceUtil;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentOperationsImpl
extends RollableScalableResourceOperation<Deployment, DeploymentList, DoneableDeployment, RollableScalableResource<Deployment, DoneableDeployment>>
implements TimeoutImageEditReplacePatchable<Deployment, Deployment, DoneableDeployment> {
    static final transient Logger LOG = LoggerFactory.getLogger(DeploymentOperationsImpl.class);

    public DeploymentOperationsImpl(OkHttpClient client, Config config) {
        this(client, config, null);
    }

    public DeploymentOperationsImpl(OkHttpClient client, Config config, String namespace) {
        this(new RollingOperationContext().withOkhttpClient(client).withConfig(config).withNamespace(namespace).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
        if (config.getNamespace() != null) {
            this.namespace = config.getNamespace();
        }
    }

    public DeploymentOperationsImpl(RollingOperationContext context) {
        super(context.withApiGroupName("apps").withApiGroupVersion("v1").withPlural("deployments"));
        this.type = Deployment.class;
        this.listType = DeploymentList.class;
        this.doneableType = DoneableDeployment.class;
    }

    public DeploymentOperationsImpl newInstance(OperationContext context) {
        return new DeploymentOperationsImpl((RollingOperationContext)context);
    }

    @Override
    public Deployment scale(int count) {
        return this.scale(count, false);
    }

    @Override
    public Deployment scale(int count, boolean wait) {
        Deployment res = ((DoneableDeployment)((DeploymentFluent.SpecNested)((DoneableDeployment)this.cascading(false).edit()).editSpec().withReplicas(count)).endSpec()).done();
        if (wait) {
            this.waitUntilDeploymentIsScaled(count);
            res = (Deployment)this.getMandatory();
        }
        return res;
    }

    @Override
    public DoneableDeployment edit() {
        if (this.isCascading().booleanValue()) {
            return (DoneableDeployment)this.cascading(false).edit();
        }
        return (DoneableDeployment)super.edit();
    }

    @Override
    public Deployment replace(Deployment item) {
        if (this.isCascading().booleanValue()) {
            return (Deployment)this.cascading(false).replace(item);
        }
        return super.replace(item);
    }

    @Override
    public Deployment patch(Deployment item) {
        if (this.isCascading().booleanValue()) {
            return (Deployment)this.cascading(false).patch(item);
        }
        return super.patch(item);
    }

    @Override
    public DeploymentOperationsImpl rolling() {
        return new DeploymentOperationsImpl(((RollingOperationContext)this.context).withRolling(true));
    }

    @Override
    public Status rollback(DeploymentRollback rollback) {
        return this.handleDeploymentRollback(rollback);
    }

    @Override
    public RollingUpdater<Deployment, DeploymentList, DoneableDeployment> getRollingUpdater(long rollingTimeout, TimeUnit rollingTimeUnit) {
        return new DeploymentRollingUpdater(this.client, this.config, this.getNamespace(), rollingTimeUnit.toMillis(rollingTimeout), this.config.getLoggingInterval());
    }

    @Override
    public Deployment withReplicas(int count) {
        return ((DoneableDeployment)((DeploymentFluent.SpecNested)((DoneableDeployment)this.cascading(false).edit()).editSpec().withReplicas(count)).endSpec()).done();
    }

    @Override
    public int getCurrentReplicas(Deployment current) {
        return current.getStatus().getReplicas();
    }

    @Override
    public int getDesiredReplicas(Deployment item) {
        return item.getSpec().getReplicas();
    }

    @Override
    public long getObservedGeneration(Deployment current) {
        return current != null && current.getStatus() != null && current.getStatus().getObservedGeneration() != null ? current.getStatus().getObservedGeneration() : -1L;
    }

    @Override
    public Deployment updateImage(String image) {
        Deployment oldRC = (Deployment)this.get();
        if (oldRC == null) {
            throw new KubernetesClientException("Existing replica set doesn't exist");
        }
        if (oldRC.getSpec().getTemplate().getSpec().getContainers().size() > 1) {
            throw new KubernetesClientException("Image update is not supported for multicontainer pods");
        }
        if (oldRC.getSpec().getTemplate().getSpec().getContainers().size() == 0) {
            throw new KubernetesClientException("Pod has no containers!");
        }
        Container updatedContainer = ((ContainerBuilder)new ContainerBuilder(oldRC.getSpec().getTemplate().getSpec().getContainers().iterator().next()).withImage(image)).build();
        DeploymentBuilder newRCBuilder = new DeploymentBuilder(oldRC);
        ((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)newRCBuilder.editMetadata().withResourceVersion(null)).endMetadata()).editSpec().editTemplate().editSpec().withContainers(Collections.singletonList(updatedContainer))).endSpec()).endTemplate()).endSpec();
        return new DeploymentRollingUpdater(this.client, this.config, this.namespace).rollUpdate(oldRC, newRCBuilder.build());
    }

    @Override
    public ImageEditReplacePatchable<Deployment, Deployment, DoneableDeployment> withTimeoutInMillis(long timeoutInMillis) {
        return new DeploymentOperationsImpl(((RollingOperationContext)this.context).withRollingTimeout(timeoutInMillis));
    }

    @Override
    public ImageEditReplacePatchable<Deployment, Deployment, DoneableDeployment> withTimeout(long timeout, TimeUnit unit) {
        return new DeploymentOperationsImpl(((RollingOperationContext)this.context).withRollingTimeUnit(unit));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilDeploymentIsScaled(int count) {
        ArrayBlockingQueue<Object> queue = new ArrayBlockingQueue<Object>(1);
        AtomicReference<Integer> replicasRef = new AtomicReference<Integer>(0);
        String name = this.checkName(this.getItem());
        String namespace = this.checkNamespace(this.getItem());
        Runnable deploymentPoller = () -> {
            try {
                long observedGeneration;
                Deployment deployment = (Deployment)this.get();
                if (deployment == null) {
                    if (count == 0) {
                        queue.put(true);
                        return;
                    }
                    queue.put(new IllegalStateException("Can't wait for Deployment: " + this.checkName(this.getItem()) + " in namespace: " + this.checkName(this.getItem()) + " to scale. Resource is no longer available."));
                    return;
                }
                replicasRef.set(deployment.getStatus().getReplicas());
                int currentReplicas = deployment.getStatus().getReplicas() != null ? deployment.getStatus().getReplicas() : 0;
                long generation = deployment.getMetadata().getGeneration() != null ? deployment.getMetadata().getGeneration() : 0L;
                long l = observedGeneration = deployment.getStatus() != null && deployment.getStatus().getObservedGeneration() != null ? deployment.getStatus().getObservedGeneration() : -1L;
                if (observedGeneration >= generation && Objects.equals(deployment.getSpec().getReplicas(), currentReplicas)) {
                    queue.put(true);
                } else {
                    LOG.debug("Only {}/{} pods scheduled for Deployment: {} in namespace: {} seconds so waiting...", new Object[]{deployment.getStatus().getReplicas(), deployment.getSpec().getReplicas(), deployment.getMetadata().getName(), namespace});
                }
            }
            catch (Throwable t) {
                LOG.error("Error while waiting for Deployment to be scaled.", t);
            }
        };
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        ScheduledFuture<?> poller = executor.scheduleWithFixedDelay(deploymentPoller, 0L, 100L, TimeUnit.MILLISECONDS);
        try {
            if (Utils.waitUntilReady(queue, this.getConfig().getScaleTimeout(), TimeUnit.MILLISECONDS)) {
                LOG.debug("{}/{} pod(s) ready for Deployment: {} in namespace: {}.", new Object[]{replicasRef.get(), count, name, namespace});
            } else {
                LOG.error("{}/{} pod(s) ready for Deployment: {} in namespace: {}  after waiting for {} seconds so giving up", new Object[]{replicasRef.get(), count, name, namespace, TimeUnit.MILLISECONDS.toSeconds(this.getConfig().getScaleTimeout())});
            }
        }
        finally {
            poller.cancel(true);
            executor.shutdown();
        }
    }

    @Override
    public String getLog() {
        return this.getLog(false);
    }

    @Override
    public String getLog(Boolean isPretty) {
        StringBuilder stringBuilder = new StringBuilder();
        List<RollableScalableResource<ReplicaSet, DoneableReplicaSet>> rcList = this.doGetLog();
        for (RollableScalableResource<ReplicaSet, DoneableReplicaSet> rcOperation : rcList) {
            stringBuilder.append((String)rcOperation.getLog(isPretty));
        }
        return stringBuilder.toString();
    }

    private List<RollableScalableResource<ReplicaSet, DoneableReplicaSet>> doGetLog() {
        ArrayList<RollableScalableResource<ReplicaSet, DoneableReplicaSet>> rcs = new ArrayList<RollableScalableResource<ReplicaSet, DoneableReplicaSet>>();
        Deployment deployment = (Deployment)this.fromServer().get();
        String rcUid = deployment.getMetadata().getUid();
        ReplicaSetOperationsImpl rsOperations = new ReplicaSetOperationsImpl((RollingOperationContext)this.context);
        ReplicaSetList rcList = (ReplicaSetList)rsOperations.withLabels((Map)deployment.getSpec().getTemplate().getMetadata().getLabels()).list();
        for (ReplicaSet rs : rcList.getItems()) {
            OwnerReference ownerReference = KubernetesResourceUtil.getControllerUid(rs);
            if (ownerReference == null || !ownerReference.getUid().equals(rcUid)) continue;
            rcs.add((RollableScalableResource<ReplicaSet, DoneableReplicaSet>)rsOperations.withName(rs.getMetadata().getName()));
        }
        return rcs;
    }

    @Override
    public Reader getLogReader() {
        List<RollableScalableResource<ReplicaSet, DoneableReplicaSet>> podResources = this.doGetLog();
        if (podResources.size() > 1) {
            throw new KubernetesClientException("Reading logs is not supported for multicontainer jobs");
        }
        if (podResources.size() == 1) {
            return podResources.get(0).getLogReader();
        }
        return null;
    }

    @Override
    public LogWatch watchLog() {
        return this.watchLog(null);
    }

    @Override
    public LogWatch watchLog(OutputStream out) {
        List<RollableScalableResource<ReplicaSet, DoneableReplicaSet>> podResources = this.doGetLog();
        if (podResources.size() > 1) {
            throw new KubernetesClientException("Watching logs is not supported for multicontainer jobs");
        }
        if (podResources.size() == 1) {
            return (LogWatch)podResources.get(0).watchLog(out);
        }
        return null;
    }
}

