/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v4_10.handlers;

import io.fabric8.kubernetes.api.model.v4_10.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v4_10.ListOptions;
import io.fabric8.kubernetes.clnt.v4_10.Config;
import io.fabric8.kubernetes.clnt.v4_10.ResourceHandler;
import io.fabric8.kubernetes.clnt.v4_10.Watch;
import io.fabric8.kubernetes.clnt.v4_10.Watcher;
import io.fabric8.kubernetes.clnt.v4_10.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v4_10.dsl.Resource;
import io.fabric8.openshift.api.model.v4_10.RoleBinding;
import io.fabric8.openshift.api.model.v4_10.RoleBindingBuilder;
import io.fabric8.openshift.clnt.v4_10.OpenShiftConfig;
import io.fabric8.openshift.clnt.v4_10.dsl.internal.RoleBindingOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class RoleBindingHandler
implements ResourceHandler<RoleBinding, RoleBindingBuilder> {
    @Override
    public String getKind() {
        return RoleBinding.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "authorization.openshift.io/v1";
    }

    @Override
    public RoleBinding create(OkHttpClient client, Config config, String namespace, RoleBinding item) {
        return (RoleBinding)new RoleBindingOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create(new RoleBinding[0]);
    }

    @Override
    public RoleBinding replace(OkHttpClient client, Config config, String namespace, RoleBinding item) {
        return (RoleBinding)((Resource)new RoleBindingOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public RoleBinding reload(OkHttpClient client, Config config, String namespace, RoleBinding item) {
        return (RoleBinding)((Gettable)((Resource)new RoleBindingOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public RoleBindingBuilder edit(RoleBinding item) {
        return new RoleBindingBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, RoleBinding item) {
        return (Boolean)new RoleBindingOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).withPropagationPolicy(propagationPolicy).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, RoleBinding item, Watcher<RoleBinding> watcher) {
        return (Watch)((Resource)new RoleBindingOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, RoleBinding item, String resourceVersion, Watcher<RoleBinding> watcher) {
        return (Watch)((Resource)new RoleBindingOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, RoleBinding item, ListOptions options, Watcher<RoleBinding> watcher) {
        return (Watch)((Resource)new RoleBindingOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public RoleBinding waitUntilReady(OkHttpClient client, Config config, String namespace, RoleBinding item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (RoleBinding)((Resource)new RoleBindingOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public RoleBinding waitUntilCondition(OkHttpClient client, Config config, String namespace, RoleBinding item, Predicate<RoleBinding> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (RoleBinding)((Resource)new RoleBindingOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

