/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v4_10.handlers;

import io.fabric8.kubernetes.api.model.v4_10.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v4_10.ListOptions;
import io.fabric8.kubernetes.clnt.v4_10.Config;
import io.fabric8.kubernetes.clnt.v4_10.ResourceHandler;
import io.fabric8.kubernetes.clnt.v4_10.Watch;
import io.fabric8.kubernetes.clnt.v4_10.Watcher;
import io.fabric8.kubernetes.clnt.v4_10.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v4_10.dsl.Resource;
import io.fabric8.openshift.api.model.v4_10.Group;
import io.fabric8.openshift.api.model.v4_10.GroupBuilder;
import io.fabric8.openshift.clnt.v4_10.OpenShiftConfig;
import io.fabric8.openshift.clnt.v4_10.dsl.internal.GroupOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class GroupHandler
implements ResourceHandler<Group, GroupBuilder> {
    @Override
    public String getKind() {
        return Group.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "user.openshift.io/v1";
    }

    @Override
    public Group create(OkHttpClient client, Config config, String namespace, Group item) {
        return (Group)new GroupOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create(new Group[0]);
    }

    @Override
    public Group replace(OkHttpClient client, Config config, String namespace, Group item) {
        return (Group)((Resource)new GroupOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public Group reload(OkHttpClient client, Config config, String namespace, Group item) {
        return (Group)((Gettable)((Resource)new GroupOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public GroupBuilder edit(Group item) {
        return new GroupBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, Group item) {
        return (Boolean)new GroupOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).withPropagationPolicy(propagationPolicy).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Group item, Watcher<Group> watcher) {
        return (Watch)((Resource)new GroupOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Group item, String resourceVersion, Watcher<Group> watcher) {
        return (Watch)((Resource)new GroupOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Group item, ListOptions options, Watcher<Group> watcher) {
        return (Watch)((Resource)new GroupOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public Group waitUntilReady(OkHttpClient client, Config config, String namespace, Group item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Group)((Resource)new GroupOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public Group waitUntilCondition(OkHttpClient client, Config config, String namespace, Group item, Predicate<Group> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Group)((Resource)new GroupOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

