/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_10.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import io.fabric8.kubernetes.api.KubernetesResourceMappingProvider;
import io.fabric8.kubernetes.api.model.v4_10.HasMetadata;
import io.fabric8.kubernetes.api.model.v4_10.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.v4_10.KubernetesResource;
import io.fabric8.kubernetes.model.annotation.ApiGroup;
import io.fabric8.kubernetes.model.annotation.ApiVersion;
import io.fabric8.kubernetes.model.util.Helper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class KubernetesDeserializer
extends JsonDeserializer<KubernetesResource> {
    private static final String KIND = "kind";
    private static final String API_VERSION = "apiVersion";
    private static final Mapping mapping = new Mapping();

    public KubernetesResource deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.readValueAsTree();
        if (node.isObject()) {
            return KubernetesDeserializer.fromObjectNode(jp, node);
        }
        if (node.isArray()) {
            return this.fromArrayNode(jp, node);
        }
        return null;
    }

    private KubernetesResource fromArrayNode(JsonParser jp, JsonNode node) throws IOException {
        Iterator iterator = node.elements();
        ArrayList<HasMetadata> list = new ArrayList<HasMetadata>();
        while (iterator.hasNext()) {
            KubernetesResource resource;
            JsonNode jsonNode = (JsonNode)iterator.next();
            if (!jsonNode.isObject() || !((resource = KubernetesDeserializer.fromObjectNode(jp, jsonNode)) instanceof HasMetadata)) continue;
            list.add((HasMetadata)resource);
        }
        return ((KubernetesListBuilder)new KubernetesListBuilder().withItems(list)).build();
    }

    private static KubernetesResource fromObjectNode(JsonParser jp, JsonNode node) throws IOException {
        String key = KubernetesDeserializer.getKey(node);
        if (key != null) {
            Class<? extends KubernetesResource> resourceType = mapping.getForKey(key);
            if (resourceType == null) {
                throw JsonMappingException.from((JsonParser)jp, (String)("No resource type found for:" + key));
            }
            if (KubernetesResource.class.isAssignableFrom(resourceType)) {
                return (KubernetesResource)jp.getCodec().treeToValue((TreeNode)node, resourceType);
            }
        }
        return null;
    }

    private static String getKey(JsonNode node) {
        JsonNode apiVersion = node.get(API_VERSION);
        JsonNode kind = node.get(KIND);
        return mapping.createKey(apiVersion != null ? apiVersion.textValue() : null, kind != null ? kind.textValue() : null);
    }

    public static void registerCustomKind(String kind, Class<? extends KubernetesResource> clazz) {
        KubernetesDeserializer.registerCustomKind(null, kind, clazz);
    }

    public static void registerCustomKind(String apiVersion, String kind, Class<? extends KubernetesResource> clazz) {
        mapping.registerKind(apiVersion, kind, clazz);
    }

    public static void registerProvider(KubernetesResourceMappingProvider provider) {
        mapping.registerProvider(provider);
    }

    static class Mapping {
        private static final String KEY_SEPARATOR = "#";
        private static final String[] PACKAGES = new String[]{"io.fabric8.kubernetes.api.model.v4_10.", "io.fabric8.kubernetes.api.model.v4_10.admission", "io.fabric8.kubernetes.api.model.v4_10.admissionregistration.v1.", "io.fabric8.kubernetes.api.model.v4_10.admissionregistration.v1beta1.", "io.fabric8.kubernetes.api.model.v4_10.apiextensions.", "io.fabric8.kubernetes.api.model.v4_10.apps.", "io.fabric8.kubernetes.api.model.v4_10.authentication.", "io.fabric8.kubernetes.api.model.v4_10.authorization.", "io.fabric8.kubernetes.api.model.v4_10.autoscaling.", "io.fabric8.kubernetes.api.model.v4_10.autoscaling.v1.", "io.fabric8.kubernetes.api.model.v4_10.autoscaling.v2beta1.", "io.fabric8.kubernetes.api.model.v4_10.autoscaling.v2beta2.", "io.fabric8.kubernetes.api.model.v4_10.batch.", "io.fabric8.kubernetes.api.model.v4_10.certificates.", "io.fabric8.kubernetes.api.model.v4_10.coordination.", "io.fabric8.kubernetes.api.model.v4_10.coordination.v1.", "io.fabric8.kubernetes.api.model.v4_10.discovery.", "io.fabric8.kubernetes.api.model.v4_10.extensions.", "io.fabric8.kubernetes.api.model.v4_10.events.", "io.fabric8.kubernetes.api.model.v4_10.networking.", "io.fabric8.kubernetes.api.model.v4_10.networking.v1beta1.", "io.fabric8.kubernetes.api.model.v4_10.policy.", "io.fabric8.kubernetes.api.model.v4_10.rbac.", "io.fabric8.kubernetes.api.model.v4_10.storage.", "io.fabric8.kubernetes.api.model.v4_10.scheduling.", "io.fabric8.kubernetes.api.model.v4_10.settings.", "io.fabric8.openshift.api.model.v4_10."};
        private Map<String, Class<? extends KubernetesResource>> mappings = new ConcurrentHashMap<String, Class<? extends KubernetesResource>>();

        Mapping() {
            this.registerAllProviders();
        }

        public Class<? extends KubernetesResource> getForKey(String key) {
            if (key == null) {
                return null;
            }
            Class<? extends KubernetesResource> clazz = this.mappings.get(key);
            if (clazz != null) {
                return clazz;
            }
            clazz = this.getInternalTypeForName(key);
            if (clazz != null) {
                this.mappings.put(key, clazz);
            }
            return clazz;
        }

        public void registerKind(String apiVersion, String kind, Class<? extends KubernetesResource> clazz) {
            this.mappings.put(this.createKey(apiVersion, kind), clazz);
        }

        public void registerProvider(KubernetesResourceMappingProvider provider) {
            if (provider == null) {
                return;
            }
            Map<String, Class> providerMappings = provider.getMappings().entrySet().stream().filter(entry -> KubernetesResource.class.isAssignableFrom((Class)entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            this.mappings.putAll(providerMappings);
        }

        String createKey(String apiVersion, String kind) {
            if (kind == null) {
                return null;
            }
            if (apiVersion == null) {
                return kind;
            }
            return apiVersion + KEY_SEPARATOR + kind;
        }

        private void registerAllProviders() {
            this.getAllMappingProviders().forEach(this::registerProvider);
        }

        Stream<KubernetesResourceMappingProvider> getAllMappingProviders() {
            Iterable currentThreadClassLoader = () -> ServiceLoader.load(KubernetesResourceMappingProvider.class, Thread.currentThread().getContextClassLoader()).iterator();
            Iterable classClassLoader = () -> ServiceLoader.load(KubernetesResourceMappingProvider.class, KubernetesDeserializer.class.getClassLoader()).iterator();
            return Stream.concat(StreamSupport.stream(currentThreadClassLoader.spliterator(), false), StreamSupport.stream(classClassLoader.spliterator(), false)).filter(this.distinctByClassName(Object::getClass));
        }

        private String getClassName(String key) {
            if (key != null && key.contains(KEY_SEPARATOR)) {
                return key.substring(key.indexOf(KEY_SEPARATOR) + 1);
            }
            return key;
        }

        private Class<? extends KubernetesResource> getInternalTypeForName(String key) {
            String name = this.getClassName(key);
            ArrayList<Class<? extends KubernetesResource>> possibleResults = new ArrayList<Class<? extends KubernetesResource>>();
            for (String aPackage : PACKAGES) {
                Class<? extends KubernetesResource> result = this.loadClassIfExists(aPackage + name);
                if (result == null) continue;
                possibleResults.add(result);
            }
            if (possibleResults.size() == 1) {
                return (Class)possibleResults.get(0);
            }
            for (Class clazz : possibleResults) {
                String defaultKeyFromClass = this.getKeyFromClass(clazz);
                if (!key.equals(defaultKeyFromClass)) continue;
                return clazz;
            }
            return null;
        }

        private String getKeyFromClass(Class<? extends KubernetesResource> clazz) {
            String apiGroup = Helper.getAnnotationValue(clazz, ApiGroup.class);
            String apiVersion = Helper.getAnnotationValue(clazz, ApiVersion.class);
            if (apiGroup != null && !apiGroup.isEmpty() && apiVersion != null && !apiVersion.isEmpty()) {
                return this.createKey(apiGroup + "/" + apiVersion, clazz.getSimpleName());
            }
            return clazz.getSimpleName();
        }

        private Class<? extends KubernetesResource> loadClassIfExists(String className) {
            try {
                Class<?> clazz = KubernetesDeserializer.class.getClassLoader().loadClass(className);
                if (!KubernetesResource.class.isAssignableFrom(clazz)) {
                    return null;
                }
                return clazz;
            }
            catch (Exception t) {
                return null;
            }
        }

        private Predicate<KubernetesResourceMappingProvider> distinctByClassName(Function<KubernetesResourceMappingProvider, Class<? extends KubernetesResourceMappingProvider>> mapperProvider) {
            ConcurrentHashMap.KeySetView existing = ConcurrentHashMap.newKeySet();
            return provider -> existing.add(((Class)mapperProvider.apply((KubernetesResourceMappingProvider)provider)).getName());
        }
    }
}

