/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_10.handlers.core.v1;

import io.fabric8.kubernetes.api.model.v4_10.ConfigMap;
import io.fabric8.kubernetes.api.model.v4_10.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.v4_10.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v4_10.ListOptions;
import io.fabric8.kubernetes.clnt.v4_10.Config;
import io.fabric8.kubernetes.clnt.v4_10.ResourceHandler;
import io.fabric8.kubernetes.clnt.v4_10.Watch;
import io.fabric8.kubernetes.clnt.v4_10.Watcher;
import io.fabric8.kubernetes.clnt.v4_10.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v4_10.dsl.Resource;
import io.fabric8.kubernetes.clnt.v4_10.dsl.internal.core.v1.ConfigMapOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class ConfigMapHandler
implements ResourceHandler<ConfigMap, ConfigMapBuilder> {
    @Override
    public String getKind() {
        return ConfigMap.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "v1";
    }

    @Override
    public ConfigMap create(OkHttpClient client, Config config, String namespace, ConfigMap item) {
        return (ConfigMap)new ConfigMapOperationsImpl(client, config).withItem(item).inNamespace(namespace).create(new ConfigMap[0]);
    }

    @Override
    public ConfigMap replace(OkHttpClient client, Config config, String namespace, ConfigMap item) {
        return (ConfigMap)((Resource)new ConfigMapOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public ConfigMap reload(OkHttpClient client, Config config, String namespace, ConfigMap item) {
        return (ConfigMap)((Gettable)((Resource)new ConfigMapOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public ConfigMapBuilder edit(ConfigMap item) {
        return new ConfigMapBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, ConfigMap item) {
        return (Boolean)new ConfigMapOperationsImpl(client, config, namespace).withItem(item).withPropagationPolicy(propagationPolicy).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, ConfigMap item, Watcher<ConfigMap> watcher) {
        return (Watch)((Resource)new ConfigMapOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, ConfigMap item, String resourceVersion, Watcher<ConfigMap> watcher) {
        return (Watch)((Resource)new ConfigMapOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, ConfigMap item, ListOptions options, Watcher<ConfigMap> watcher) {
        return (Watch)((Resource)new ConfigMapOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public ConfigMap waitUntilReady(OkHttpClient client, Config config, String namespace, ConfigMap item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ConfigMap)((Resource)new ConfigMapOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public ConfigMap waitUntilCondition(OkHttpClient client, Config config, String namespace, ConfigMap item, Predicate<ConfigMap> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ConfigMap)((Resource)new ConfigMapOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

