/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_10.dsl.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mifmif.common.regex.Generex;
import io.fabric8.kubernetes.api.builder.v4_10.TypedVisitor;
import io.fabric8.kubernetes.api.builder.v4_10.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.v4_10.Visitor;
import io.fabric8.kubernetes.api.model.v4_10.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v4_10.HasMetadata;
import io.fabric8.kubernetes.api.model.v4_10.KubernetesList;
import io.fabric8.kubernetes.api.model.v4_10.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.v4_10.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.v4_10.ObjectMetaBuilder;
import io.fabric8.kubernetes.clnt.v4_10.Config;
import io.fabric8.kubernetes.clnt.v4_10.Handlers;
import io.fabric8.kubernetes.clnt.v4_10.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v4_10.KubernetesClientTimeoutException;
import io.fabric8.kubernetes.clnt.v4_10.ResourceHandler;
import io.fabric8.kubernetes.clnt.v4_10.dsl.Applicable;
import io.fabric8.kubernetes.clnt.v4_10.dsl.CascadingDeletable;
import io.fabric8.kubernetes.clnt.v4_10.dsl.Deletable;
import io.fabric8.kubernetes.clnt.v4_10.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v4_10.dsl.ListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v4_10.dsl.NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v4_10.dsl.ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v4_10.dsl.Readiable;
import io.fabric8.kubernetes.clnt.v4_10.dsl.Waitable;
import io.fabric8.kubernetes.clnt.v4_10.dsl.base.OperationSupport;
import io.fabric8.kubernetes.clnt.v4_10.handlers.KubernetesListHandler;
import io.fabric8.kubernetes.clnt.v4_10.internal.readiness.Readiness;
import io.fabric8.kubernetes.clnt.v4_10.utils.ResourceCompare;
import io.fabric8.kubernetes.clnt.v4_10.utils.Serialization;
import io.fabric8.kubernetes.clnt.v4_10.utils.Utils;
import io.fabric8.openshift.api.model.v4_10.Parameter;
import io.fabric8.openshift.api.model.v4_10.Template;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl
extends OperationSupport
implements ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean>,
Waitable<List<HasMetadata>, HasMetadata>,
Readiable {
    private static final Logger LOGGER = LoggerFactory.getLogger(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl.class);
    private static final String EXPRESSION = "expression";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final String fallbackNamespace;
    private final String explicitNamespace;
    private final Boolean fromServer;
    private final Boolean deletingExisting;
    private final List<Visitor> visitors;
    private final long watchRetryInitialBackoffMillis;
    private final double watchRetryBackoffMultiplier;
    private final Object item;
    private final InputStream inputStream;
    private final long gracePeriodSeconds;
    private final DeletionPropagation propagationPolicy;
    private final Boolean cascading;

    @Override
    public List<HasMetadata> waitUntilReady(long amount, TimeUnit timeUnit) throws InterruptedException {
        List<HasMetadata> items = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl.acceptVisitors(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl.asHasMetadata(this.item, true), this.visitors);
        if (items.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList();
        ArrayList<HasMetadata> itemsWithConditionNotMatched = new ArrayList<HasMetadata>(items);
        int size = items.size();
        ExecutorService executor = Executors.newFixedThreadPool(size);
        try {
            CountDownLatch latch = new CountDownLatch(size);
            for (HasMetadata meta : items) {
                ResourceHandler h = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl.handlerOf(meta);
                executor.submit(() -> {
                    try {
                        result.add(h.waitUntilReady(this.client, this.config, meta.getMetadata().getNamespace(), meta, amount, timeUnit));
                    }
                    catch (IllegalArgumentException | InterruptedException interruptedException) {
                        LOGGER.info(meta.getKind() + " " + meta.getMetadata().getName() + " does not support readiness. skipping..");
                        latch.countDown();
                    }
                    catch (IllegalStateException t) {
                        LOGGER.warn("Error while waiting for: [" + meta.getKind() + "] with name: [" + meta.getMetadata().getName() + "] in namespace: [" + meta.getMetadata().getNamespace() + "]: " + t.getMessage() + ". The resource will be considered not ready.");
                        LOGGER.debug("The error stack trace:", (Throwable)t);
                    }
                    finally {
                        latch.countDown();
                    }
                });
            }
            latch.await(amount, timeUnit);
            if (latch.getCount() == 0L) {
                ArrayList arrayList = result;
                return arrayList;
            }
            throw new KubernetesClientTimeoutException(itemsWithConditionNotMatched, amount, timeUnit);
        }
        finally {
            executor.shutdown();
        }
    }

    @Override
    public List<HasMetadata> waitUntilCondition(Predicate<HasMetadata> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        List<HasMetadata> items = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl.acceptVisitors(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl.asHasMetadata(this.item, true), this.visitors);
        if (items.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList();
        ArrayList<HasMetadata> itemsWithConditionNotMatched = new ArrayList<HasMetadata>(items);
        int size = items.size();
        AtomicInteger conditionMatched = new AtomicInteger(0);
        ExecutorService executor = Executors.newFixedThreadPool(size);
        try {
            CountDownLatch latch = new CountDownLatch(size);
            for (HasMetadata meta : items) {
                ResourceHandler h = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl.handlerOf(meta);
                executor.submit(() -> {
                    try {
                        result.add(h.waitUntilCondition(this.client, this.config, meta.getMetadata().getNamespace(), meta, condition, amount, timeUnit));
                        conditionMatched.incrementAndGet();
                        itemsWithConditionNotMatched.remove(meta);
                    }
                    catch (Throwable t) {
                        LOGGER.warn("Error while waiting for: [" + meta.getKind() + "] with name: [" + meta.getMetadata().getName() + "] in namespace: [" + meta.getMetadata().getNamespace() + "]: " + t.getMessage() + ". The resource will be considered not ready.");
                        LOGGER.debug("The error stack trace:", t);
                    }
                    finally {
                        latch.countDown();
                    }
                });
            }
            if (NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl.checkConditionMetForAll(latch, size, conditionMatched, amount, timeUnit)) {
                ArrayList arrayList = result;
                return arrayList;
            }
            throw new KubernetesClientTimeoutException(itemsWithConditionNotMatched, amount, timeUnit);
        }
        finally {
            executor.shutdown();
        }
    }

    @Override
    public Boolean isReady() {
        for (HasMetadata meta : NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl.acceptVisitors((List<HasMetadata>)this.get(), this.visitors)) {
            if (Readiness.isReady(meta)) continue;
            return false;
        }
        return true;
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> withParameters(Map<String, String> parameters) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this.client, this.config, this.namespace, this.explicitNamespace, this.fromServer, this.deletingExisting, this.visitors, null, this.inputStream, parameters, -1L, this.propagationPolicy, this.cascading, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier);
    }

    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(OkHttpClient client, Config config, String namespace, String explicitNamespace, Boolean fromServer, Boolean deletingExisting, List<Visitor> visitors, InputStream is, Map<String, String> parameters, Boolean cascading, DeletionPropagation propagationPolicy) {
        this(client, config, namespace, explicitNamespace, fromServer, deletingExisting, visitors, null, is, parameters, -1L, propagationPolicy, cascading, 5L, 2.0);
    }

    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(OkHttpClient client, Config config, String namespace, String explicitNamespace, Boolean fromServer, Boolean deletingExisting, List<Visitor> visitors, Object item, Map<String, String> parameters, DeletionPropagation propagationPolicy, Boolean cascading) {
        this(client, config, namespace, explicitNamespace, fromServer, deletingExisting, visitors, item, null, parameters, -1L, propagationPolicy, cascading, 5L, 2.0);
    }

    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(OkHttpClient client, Config config, String namespace, String explicitNamespace, Boolean fromServer, Boolean deletingExisting, List<Visitor> visitors, Object item, InputStream inputStream, Map<String, String> parameters, long gracePeriodSeconds, DeletionPropagation propagationPolicy, Boolean cascading, long watchRetryInitialBackoffMillis, double watchRetryBackoffMultiplier) {
        super(client, config);
        this.fallbackNamespace = namespace;
        this.explicitNamespace = explicitNamespace;
        this.fromServer = fromServer;
        this.deletingExisting = deletingExisting;
        this.visitors = visitors != null ? new ArrayList<Visitor>(visitors) : new ArrayList();
        this.watchRetryInitialBackoffMillis = watchRetryInitialBackoffMillis;
        this.watchRetryBackoffMultiplier = watchRetryBackoffMultiplier;
        if (item != null) {
            this.item = item;
        } else if (inputStream != null) {
            this.item = Serialization.unmarshal(inputStream, parameters);
        } else {
            throw new IllegalArgumentException("Need to either specify an Object or an InputStream.");
        }
        this.inputStream = inputStream;
        this.cascading = cascading;
        this.gracePeriodSeconds = gracePeriodSeconds;
        this.propagationPolicy = propagationPolicy;
        this.visitors.add(new ChangeNamespace(explicitNamespace, this.fallbackNamespace));
    }

    @Override
    public List<HasMetadata> apply() {
        return this.createOrReplace();
    }

    @Override
    public List<HasMetadata> createOrReplace() {
        ArrayList<HasMetadata> result = new ArrayList<HasMetadata>();
        for (HasMetadata meta : NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl.acceptVisitors(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl.asHasMetadata(this.item, true), this.visitors)) {
            ResourceHandler h = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl.handlerOf(meta);
            HasMetadata r = h.reload(this.client, this.config, meta.getMetadata().getNamespace(), meta);
            String namespaceToUse = meta.getMetadata().getNamespace();
            if (r == null) {
                HasMetadata created = h.create(this.client, this.config, namespaceToUse, meta);
                if (created == null) continue;
                result.add(created);
                continue;
            }
            if (this.deletingExisting.booleanValue()) {
                Boolean deleted = h.delete(this.client, this.config, namespaceToUse, this.propagationPolicy, meta);
                if (!deleted.booleanValue()) {
                    throw new KubernetesClientException("Failed to delete existing item:" + meta);
                }
                HasMetadata created = h.create(this.client, this.config, namespaceToUse, meta);
                if (created == null) continue;
                result.add(created);
                continue;
            }
            if (ResourceCompare.equals(r, meta)) {
                LOGGER.debug("Item has not changed. Skipping");
                continue;
            }
            HasMetadata replaced = h.replace(this.client, this.config, namespaceToUse, meta);
            if (replaced == null) continue;
            result.add(replaced);
        }
        return result;
    }

    @Override
    public Waitable<List<HasMetadata>, HasMetadata> createOrReplaceAnd() {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, this.deletingExisting, this.visitors, this.createOrReplace(), this.inputStream, null, this.gracePeriodSeconds, this.propagationPolicy, this.cascading, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier);
    }

    @Override
    public Boolean delete() {
        for (HasMetadata meta : NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl.acceptVisitors(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl.asHasMetadata(this.item, true), this.visitors)) {
            if (NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl.handlerOf(meta) != null) continue;
            return false;
        }
        for (HasMetadata meta : NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl.acceptVisitors(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl.asHasMetadata(this.item, true), this.visitors)) {
            ResourceHandler h = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl.handlerOf(meta);
            if (h.delete(this.client, this.config, meta.getMetadata().getNamespace(), this.propagationPolicy, meta).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<HasMetadata> get() {
        if (this.fromServer.booleanValue()) {
            ArrayList<HasMetadata> result = new ArrayList<HasMetadata>();
            for (HasMetadata meta : NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl.acceptVisitors(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl.asHasMetadata(this.item, true), this.visitors)) {
                ResourceHandler h = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl.handlerOf(meta);
                HasMetadata reloaded = h.reload(this.client, this.config, meta.getMetadata().getNamespace(), meta);
                if (reloaded == null) continue;
                HasMetadata edited = reloaded;
                for (Visitor v : this.visitors) {
                    ((VisitableBuilder)h.edit(edited).accept(v)).build();
                }
                result.add(reloaded);
            }
            return result;
        }
        return NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl.acceptVisitors(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl.asHasMetadata(this.item, true), this.visitors);
    }

    private static List<HasMetadata> acceptVisitors(List<HasMetadata> list, List<Visitor> visitors) {
        ArrayList<HasMetadata> result = new ArrayList<HasMetadata>();
        for (HasMetadata item : list) {
            ResourceHandler h = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl.handlerOf(item);
            Object builder = h.edit(item);
            for (Visitor v : visitors) {
                builder.accept(v);
            }
            result.add((HasMetadata)builder.build());
        }
        return result;
    }

    @Override
    public ListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> inNamespace(String explicitNamespace) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this.client, this.config, this.fallbackNamespace, explicitNamespace, this.fromServer, this.deletingExisting, this.visitors, this.item, null, null, this.gracePeriodSeconds, this.propagationPolicy, this.cascading, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier);
    }

    @Override
    public Gettable<List<HasMetadata>> fromServer() {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, true, this.deletingExisting, this.visitors, this.item, null, null, this.gracePeriodSeconds, this.propagationPolicy, this.cascading, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier);
    }

    @Override
    public Applicable<List<HasMetadata>> deletingExisting() {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, true, this.visitors, this.item, null, null, this.gracePeriodSeconds, this.propagationPolicy, this.cascading, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier);
    }

    @Override
    public ListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> accept(Visitor visitor) {
        ArrayList<Visitor> newVisitors = new ArrayList<Visitor>(this.visitors);
        newVisitors.add(visitor);
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, true, newVisitors, this.item, null, null, this.gracePeriodSeconds, this.propagationPolicy, this.cascading, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier);
    }

    @Override
    public CascadingDeletable<Boolean> withGracePeriod(long gracePeriodSeconds) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, true, this.visitors, this.item, null, null, gracePeriodSeconds, this.propagationPolicy, this.cascading, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier);
    }

    @Override
    public CascadingDeletable<Boolean> withPropagationPolicy(DeletionPropagation propagationPolicy) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, true, this.visitors, this.item, null, null, this.gracePeriodSeconds, propagationPolicy, this.cascading, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier);
    }

    @Override
    public Waitable<List<HasMetadata>, HasMetadata> withWaitRetryBackoff(long initialBackoff, TimeUnit backoffUnit, double backoffMultiplier) {
        long watchRetryInitialBackoffMillis = backoffUnit.toMillis(initialBackoff);
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, true, this.visitors, this.item, null, null, this.gracePeriodSeconds, this.propagationPolicy, this.cascading, watchRetryInitialBackoffMillis, backoffMultiplier);
    }

    @Override
    public Deletable<Boolean> cascading(boolean cascading) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, true, this.visitors, this.item, null, null, this.gracePeriodSeconds, this.propagationPolicy, cascading, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> List<HasMetadata> asHasMetadata(T item, Boolean enableProccessing) {
        ArrayList<HasMetadata> result = new ArrayList<HasMetadata>();
        if (item instanceof KubernetesList) {
            result.addAll(((KubernetesList)item).getItems());
            return result;
        }
        if (item instanceof Template) {
            if (!enableProccessing.booleanValue()) {
                result.addAll(((Template)item).getObjects());
                return result;
            }
            result.addAll(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl.processTemplate((Template)item, false));
            return result;
        }
        if (item instanceof KubernetesResourceList) {
            result.addAll(((KubernetesResourceList)item).getItems());
            return result;
        }
        if (item instanceof HasMetadata) {
            result.add((HasMetadata)item);
            return result;
        }
        if (item instanceof String) {
            try (ByteArrayInputStream is = new ByteArrayInputStream(((String)item).getBytes(StandardCharsets.UTF_8));){
                List<HasMetadata> list = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl.asHasMetadata(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl.unmarshal(is), enableProccessing);
                return list;
            }
            catch (IOException e) {
                throw KubernetesClientException.launderThrowable(e);
            }
        }
        if (!(item instanceof Collection)) return result;
        Iterator iterator = ((Collection)item).iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (!(o instanceof HasMetadata)) continue;
            result.add((HasMetadata)o);
        }
        return result;
    }

    private static <T> ResourceHandler handlerOf(T item) {
        if (item instanceof HasMetadata) {
            return Handlers.get(((HasMetadata)item).getKind(), ((HasMetadata)item).getApiVersion());
        }
        if (item instanceof KubernetesList) {
            return new KubernetesListHandler();
        }
        throw new IllegalArgumentException("Could not find a registered handler for item: [" + item + "].");
    }

    private static List<HasMetadata> processTemplate(Template template, Boolean failOnMissing) {
        List<Parameter> parameters = template != null ? template.getParameters() : null;
        KubernetesList list = ((KubernetesListBuilder)new KubernetesListBuilder().withItems(template.getObjects())).build();
        try {
            String json = OBJECT_MAPPER.writeValueAsString((Object)list);
            if (parameters != null && !parameters.isEmpty()) {
                for (int i = 0; i < 5; ++i) {
                    for (Parameter parameter : parameters) {
                        String value;
                        String name = parameter.getName();
                        String regex = "${" + name + "}";
                        if (Utils.isNotNullOrEmpty(parameter.getValue())) {
                            value = parameter.getValue();
                        } else if (EXPRESSION.equals(parameter.getGenerate())) {
                            Generex generex = new Generex(parameter.getFrom());
                            value = generex.random();
                        } else {
                            if (failOnMissing.booleanValue()) {
                                throw new IllegalArgumentException("No value available for parameter name: " + name);
                            }
                            value = "";
                        }
                        json = json.replace(regex, value);
                    }
                }
            }
            list = (KubernetesList)OBJECT_MAPPER.readValue(json, KubernetesList.class);
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
        return list.getItems();
    }

    private static boolean checkConditionMetForAll(CountDownLatch latch, int expected, AtomicInteger actual, long amount, TimeUnit timeUnit) {
        try {
            if (latch.await(amount, timeUnit)) {
                return actual.intValue() == expected;
            }
            return false;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    private class ChangeNamespace
    extends TypedVisitor<ObjectMetaBuilder> {
        private final String explicitNamespace;
        private final String fallbackNamespace;

        private ChangeNamespace(String explicitNamespace, String fallbackNamespace) {
            this.explicitNamespace = explicitNamespace;
            this.fallbackNamespace = fallbackNamespace;
        }

        @Override
        public void visit(ObjectMetaBuilder builder) {
            if (Utils.isNotNullOrEmpty(this.explicitNamespace)) {
                builder.withNamespace(this.explicitNamespace);
            } else if (Utils.isNullOrEmpty(builder.getNamespace())) {
                builder.withNamespace(this.fallbackNamespace);
            }
        }
    }
}

