/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_10;

import io.fabric8.kubernetes.api.builder.v4_10.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_10.Nested;
import io.fabric8.kubernetes.api.builder.v4_10.Predicate;
import io.fabric8.kubernetes.api.model.v4_10.NodeConfigSource;
import io.fabric8.kubernetes.api.model.v4_10.NodeConfigSourceBuilder;
import io.fabric8.kubernetes.api.model.v4_10.NodeConfigSourceFluentImpl;
import io.fabric8.kubernetes.api.model.v4_10.NodeSpec;
import io.fabric8.kubernetes.api.model.v4_10.NodeSpecFluent;
import io.fabric8.kubernetes.api.model.v4_10.Taint;
import io.fabric8.kubernetes.api.model.v4_10.TaintBuilder;
import io.fabric8.kubernetes.api.model.v4_10.TaintFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class NodeSpecFluentImpl<A extends NodeSpecFluent<A>>
extends BaseFluent<A>
implements NodeSpecFluent<A> {
    private NodeConfigSourceBuilder configSource;
    private String externalID;
    private String podCIDR;
    private List<String> podCIDRs = new ArrayList<String>();
    private String providerID;
    private List<TaintBuilder> taints = new ArrayList<TaintBuilder>();
    private Boolean unschedulable;

    public NodeSpecFluentImpl() {
    }

    public NodeSpecFluentImpl(NodeSpec instance) {
        this.withConfigSource(instance.getConfigSource());
        this.withExternalID(instance.getExternalID());
        this.withPodCIDR(instance.getPodCIDR());
        this.withPodCIDRs(instance.getPodCIDRs());
        this.withProviderID(instance.getProviderID());
        this.withTaints(instance.getTaints());
        this.withUnschedulable(instance.getUnschedulable());
    }

    @Override
    @Deprecated
    public NodeConfigSource getConfigSource() {
        return this.configSource != null ? this.configSource.build() : null;
    }

    @Override
    public NodeConfigSource buildConfigSource() {
        return this.configSource != null ? this.configSource.build() : null;
    }

    @Override
    public A withConfigSource(NodeConfigSource configSource) {
        this._visitables.get("configSource").remove(this.configSource);
        if (configSource != null) {
            this.configSource = new NodeConfigSourceBuilder(configSource);
            this._visitables.get("configSource").add(this.configSource);
        }
        return (A)this;
    }

    @Override
    public Boolean hasConfigSource() {
        return this.configSource != null;
    }

    @Override
    public NodeSpecFluent.ConfigSourceNested<A> withNewConfigSource() {
        return new ConfigSourceNestedImpl();
    }

    @Override
    public NodeSpecFluent.ConfigSourceNested<A> withNewConfigSourceLike(NodeConfigSource item) {
        return new ConfigSourceNestedImpl(item);
    }

    @Override
    public NodeSpecFluent.ConfigSourceNested<A> editConfigSource() {
        return this.withNewConfigSourceLike(this.getConfigSource());
    }

    @Override
    public NodeSpecFluent.ConfigSourceNested<A> editOrNewConfigSource() {
        return this.withNewConfigSourceLike(this.getConfigSource() != null ? this.getConfigSource() : new NodeConfigSourceBuilder().build());
    }

    @Override
    public NodeSpecFluent.ConfigSourceNested<A> editOrNewConfigSourceLike(NodeConfigSource item) {
        return this.withNewConfigSourceLike(this.getConfigSource() != null ? this.getConfigSource() : item);
    }

    @Override
    public String getExternalID() {
        return this.externalID;
    }

    @Override
    public A withExternalID(String externalID) {
        this.externalID = externalID;
        return (A)this;
    }

    @Override
    public Boolean hasExternalID() {
        return this.externalID != null;
    }

    @Override
    public A withNewExternalID(String arg1) {
        return this.withExternalID(new String(arg1));
    }

    @Override
    public A withNewExternalID(StringBuilder arg1) {
        return this.withExternalID(new String(arg1));
    }

    @Override
    public A withNewExternalID(StringBuffer arg1) {
        return this.withExternalID(new String(arg1));
    }

    @Override
    public String getPodCIDR() {
        return this.podCIDR;
    }

    @Override
    public A withPodCIDR(String podCIDR) {
        this.podCIDR = podCIDR;
        return (A)this;
    }

    @Override
    public Boolean hasPodCIDR() {
        return this.podCIDR != null;
    }

    @Override
    public A withNewPodCIDR(String arg1) {
        return this.withPodCIDR(new String(arg1));
    }

    @Override
    public A withNewPodCIDR(StringBuilder arg1) {
        return this.withPodCIDR(new String(arg1));
    }

    @Override
    public A withNewPodCIDR(StringBuffer arg1) {
        return this.withPodCIDR(new String(arg1));
    }

    @Override
    public A addToPodCIDRs(int index, String item) {
        if (this.podCIDRs == null) {
            this.podCIDRs = new ArrayList<String>();
        }
        this.podCIDRs.add(index, item);
        return (A)this;
    }

    @Override
    public A setToPodCIDRs(int index, String item) {
        if (this.podCIDRs == null) {
            this.podCIDRs = new ArrayList<String>();
        }
        this.podCIDRs.set(index, item);
        return (A)this;
    }

    @Override
    public A addToPodCIDRs(String ... items) {
        if (this.podCIDRs == null) {
            this.podCIDRs = new ArrayList<String>();
        }
        for (String item : items) {
            this.podCIDRs.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToPodCIDRs(Collection<String> items) {
        if (this.podCIDRs == null) {
            this.podCIDRs = new ArrayList<String>();
        }
        for (String item : items) {
            this.podCIDRs.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromPodCIDRs(String ... items) {
        for (String item : items) {
            if (this.podCIDRs == null) continue;
            this.podCIDRs.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPodCIDRs(Collection<String> items) {
        for (String item : items) {
            if (this.podCIDRs == null) continue;
            this.podCIDRs.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getPodCIDRs() {
        return this.podCIDRs;
    }

    @Override
    public String getPodCIDR(int index) {
        return this.podCIDRs.get(index);
    }

    @Override
    public String getFirstPodCIDR() {
        return this.podCIDRs.get(0);
    }

    @Override
    public String getLastPodCIDR() {
        return this.podCIDRs.get(this.podCIDRs.size() - 1);
    }

    @Override
    public String getMatchingPodCIDR(Predicate<String> predicate) {
        for (String item : this.podCIDRs) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPodCIDR(Predicate<String> predicate) {
        for (String item : this.podCIDRs) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPodCIDRs(List<String> podCIDRs) {
        if (this.podCIDRs != null) {
            this._visitables.get("podCIDRs").removeAll(this.podCIDRs);
        }
        if (podCIDRs != null) {
            this.podCIDRs = new ArrayList<String>();
            for (String item : podCIDRs) {
                this.addToPodCIDRs(item);
            }
        } else {
            this.podCIDRs = null;
        }
        return (A)this;
    }

    @Override
    public A withPodCIDRs(String ... podCIDRs) {
        if (this.podCIDRs != null) {
            this.podCIDRs.clear();
        }
        if (podCIDRs != null) {
            for (String item : podCIDRs) {
                this.addToPodCIDRs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPodCIDRs() {
        return this.podCIDRs != null && !this.podCIDRs.isEmpty();
    }

    @Override
    public A addNewPodCIDR(String arg1) {
        return this.addToPodCIDRs(new String(arg1));
    }

    @Override
    public A addNewPodCIDR(StringBuilder arg1) {
        return this.addToPodCIDRs(new String(arg1));
    }

    @Override
    public A addNewPodCIDR(StringBuffer arg1) {
        return this.addToPodCIDRs(new String(arg1));
    }

    @Override
    public String getProviderID() {
        return this.providerID;
    }

    @Override
    public A withProviderID(String providerID) {
        this.providerID = providerID;
        return (A)this;
    }

    @Override
    public Boolean hasProviderID() {
        return this.providerID != null;
    }

    @Override
    public A withNewProviderID(String arg1) {
        return this.withProviderID(new String(arg1));
    }

    @Override
    public A withNewProviderID(StringBuilder arg1) {
        return this.withProviderID(new String(arg1));
    }

    @Override
    public A withNewProviderID(StringBuffer arg1) {
        return this.withProviderID(new String(arg1));
    }

    @Override
    public A addToTaints(int index, Taint item) {
        if (this.taints == null) {
            this.taints = new ArrayList<TaintBuilder>();
        }
        TaintBuilder builder = new TaintBuilder(item);
        this._visitables.get("taints").add(index >= 0 ? index : this._visitables.get("taints").size(), builder);
        this.taints.add(index >= 0 ? index : this.taints.size(), builder);
        return (A)this;
    }

    @Override
    public A setToTaints(int index, Taint item) {
        if (this.taints == null) {
            this.taints = new ArrayList<TaintBuilder>();
        }
        TaintBuilder builder = new TaintBuilder(item);
        if (index < 0 || index >= this._visitables.get("taints").size()) {
            this._visitables.get("taints").add(builder);
        } else {
            this._visitables.get("taints").set(index, builder);
        }
        if (index < 0 || index >= this.taints.size()) {
            this.taints.add(builder);
        } else {
            this.taints.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToTaints(Taint ... items) {
        if (this.taints == null) {
            this.taints = new ArrayList<TaintBuilder>();
        }
        for (Taint item : items) {
            TaintBuilder builder = new TaintBuilder(item);
            this._visitables.get("taints").add(builder);
            this.taints.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToTaints(Collection<Taint> items) {
        if (this.taints == null) {
            this.taints = new ArrayList<TaintBuilder>();
        }
        for (Taint item : items) {
            TaintBuilder builder = new TaintBuilder(item);
            this._visitables.get("taints").add(builder);
            this.taints.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromTaints(Taint ... items) {
        for (Taint item : items) {
            TaintBuilder builder = new TaintBuilder(item);
            this._visitables.get("taints").remove(builder);
            if (this.taints == null) continue;
            this.taints.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTaints(Collection<Taint> items) {
        for (Taint item : items) {
            TaintBuilder builder = new TaintBuilder(item);
            this._visitables.get("taints").remove(builder);
            if (this.taints == null) continue;
            this.taints.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromTaints(Predicate<TaintBuilder> predicate) {
        if (this.taints == null) {
            return (A)this;
        }
        Iterator<TaintBuilder> each = this.taints.iterator();
        Object visitables = this._visitables.get("taints");
        while (each.hasNext()) {
            TaintBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Taint> getTaints() {
        return NodeSpecFluentImpl.build(this.taints);
    }

    @Override
    public List<Taint> buildTaints() {
        return NodeSpecFluentImpl.build(this.taints);
    }

    @Override
    public Taint buildTaint(int index) {
        return this.taints.get(index).build();
    }

    @Override
    public Taint buildFirstTaint() {
        return this.taints.get(0).build();
    }

    @Override
    public Taint buildLastTaint() {
        return this.taints.get(this.taints.size() - 1).build();
    }

    @Override
    public Taint buildMatchingTaint(Predicate<TaintBuilder> predicate) {
        for (TaintBuilder item : this.taints) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTaint(Predicate<TaintBuilder> predicate) {
        for (TaintBuilder item : this.taints) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTaints(List<Taint> taints) {
        if (this.taints != null) {
            this._visitables.get("taints").removeAll(this.taints);
        }
        if (taints != null) {
            this.taints = new ArrayList<TaintBuilder>();
            for (Taint item : taints) {
                this.addToTaints(item);
            }
        } else {
            this.taints = null;
        }
        return (A)this;
    }

    @Override
    public A withTaints(Taint ... taints) {
        if (this.taints != null) {
            this.taints.clear();
        }
        if (taints != null) {
            for (Taint item : taints) {
                this.addToTaints(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTaints() {
        return this.taints != null && !this.taints.isEmpty();
    }

    @Override
    public A addNewTaint(String effect, String key, String timeAdded, String value) {
        return this.addToTaints(new Taint(effect, key, timeAdded, value));
    }

    @Override
    public NodeSpecFluent.TaintsNested<A> addNewTaint() {
        return new TaintsNestedImpl();
    }

    @Override
    public NodeSpecFluent.TaintsNested<A> addNewTaintLike(Taint item) {
        return new TaintsNestedImpl(-1, item);
    }

    @Override
    public NodeSpecFluent.TaintsNested<A> setNewTaintLike(int index, Taint item) {
        return new TaintsNestedImpl(index, item);
    }

    @Override
    public NodeSpecFluent.TaintsNested<A> editTaint(int index) {
        if (this.taints.size() <= index) {
            throw new RuntimeException("Can't edit taints. Index exceeds size.");
        }
        return this.setNewTaintLike(index, this.buildTaint(index));
    }

    @Override
    public NodeSpecFluent.TaintsNested<A> editFirstTaint() {
        if (this.taints.size() == 0) {
            throw new RuntimeException("Can't edit first taints. The list is empty.");
        }
        return this.setNewTaintLike(0, this.buildTaint(0));
    }

    @Override
    public NodeSpecFluent.TaintsNested<A> editLastTaint() {
        int index = this.taints.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last taints. The list is empty.");
        }
        return this.setNewTaintLike(index, this.buildTaint(index));
    }

    @Override
    public NodeSpecFluent.TaintsNested<A> editMatchingTaint(Predicate<TaintBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.taints.size(); ++i) {
            if (!predicate.apply(this.taints.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching taints. No match found.");
        }
        return this.setNewTaintLike(index, this.buildTaint(index));
    }

    @Override
    public Boolean isUnschedulable() {
        return this.unschedulable;
    }

    @Override
    public A withUnschedulable(Boolean unschedulable) {
        this.unschedulable = unschedulable;
        return (A)this;
    }

    @Override
    public Boolean hasUnschedulable() {
        return this.unschedulable != null;
    }

    @Override
    public A withNewUnschedulable(String arg1) {
        return this.withUnschedulable(new Boolean(arg1));
    }

    @Override
    public A withNewUnschedulable(boolean arg1) {
        return this.withUnschedulable(new Boolean(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeSpecFluentImpl that = (NodeSpecFluentImpl)o;
        if (this.configSource != null ? !this.configSource.equals(that.configSource) : that.configSource != null) {
            return false;
        }
        if (this.externalID != null ? !this.externalID.equals(that.externalID) : that.externalID != null) {
            return false;
        }
        if (this.podCIDR != null ? !this.podCIDR.equals(that.podCIDR) : that.podCIDR != null) {
            return false;
        }
        if (this.podCIDRs != null ? !this.podCIDRs.equals(that.podCIDRs) : that.podCIDRs != null) {
            return false;
        }
        if (this.providerID != null ? !this.providerID.equals(that.providerID) : that.providerID != null) {
            return false;
        }
        if (this.taints != null ? !this.taints.equals(that.taints) : that.taints != null) {
            return false;
        }
        return !(this.unschedulable != null ? !this.unschedulable.equals(that.unschedulable) : that.unschedulable != null);
    }

    public class TaintsNestedImpl<N>
    extends TaintFluentImpl<NodeSpecFluent.TaintsNested<N>>
    implements NodeSpecFluent.TaintsNested<N>,
    Nested<N> {
        private final TaintBuilder builder;
        private final int index;

        TaintsNestedImpl(int index, Taint item) {
            this.index = index;
            this.builder = new TaintBuilder(this, item);
        }

        TaintsNestedImpl() {
            this.index = -1;
            this.builder = new TaintBuilder(this);
        }

        @Override
        public N and() {
            return (N)NodeSpecFluentImpl.this.setToTaints(this.index, this.builder.build());
        }

        @Override
        public N endTaint() {
            return this.and();
        }
    }

    public class ConfigSourceNestedImpl<N>
    extends NodeConfigSourceFluentImpl<NodeSpecFluent.ConfigSourceNested<N>>
    implements NodeSpecFluent.ConfigSourceNested<N>,
    Nested<N> {
        private final NodeConfigSourceBuilder builder;

        ConfigSourceNestedImpl(NodeConfigSource item) {
            this.builder = new NodeConfigSourceBuilder(this, item);
        }

        ConfigSourceNestedImpl() {
            this.builder = new NodeConfigSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)NodeSpecFluentImpl.this.withConfigSource(this.builder.build());
        }

        @Override
        public N endConfigSource() {
            return this.and();
        }
    }
}

