/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_10;

import io.fabric8.kubernetes.api.builder.v4_10.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_10.Nested;
import io.fabric8.kubernetes.api.builder.v4_10.Predicate;
import io.fabric8.kubernetes.api.model.v4_10.CephFSVolumeSource;
import io.fabric8.kubernetes.api.model.v4_10.CephFSVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.v4_10.LocalObjectReference;
import io.fabric8.kubernetes.api.model.v4_10.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v4_10.LocalObjectReferenceFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CephFSVolumeSourceFluentImpl<A extends CephFSVolumeSourceFluent<A>>
extends BaseFluent<A>
implements CephFSVolumeSourceFluent<A> {
    private List<String> monitors = new ArrayList<String>();
    private String path;
    private Boolean readOnly;
    private String secretFile;
    private LocalObjectReferenceBuilder secretRef;
    private String user;

    public CephFSVolumeSourceFluentImpl() {
    }

    public CephFSVolumeSourceFluentImpl(CephFSVolumeSource instance) {
        this.withMonitors(instance.getMonitors());
        this.withPath(instance.getPath());
        this.withReadOnly(instance.getReadOnly());
        this.withSecretFile(instance.getSecretFile());
        this.withSecretRef(instance.getSecretRef());
        this.withUser(instance.getUser());
    }

    @Override
    public A addToMonitors(int index, String item) {
        if (this.monitors == null) {
            this.monitors = new ArrayList<String>();
        }
        this.monitors.add(index, item);
        return (A)this;
    }

    @Override
    public A setToMonitors(int index, String item) {
        if (this.monitors == null) {
            this.monitors = new ArrayList<String>();
        }
        this.monitors.set(index, item);
        return (A)this;
    }

    @Override
    public A addToMonitors(String ... items) {
        if (this.monitors == null) {
            this.monitors = new ArrayList<String>();
        }
        for (String item : items) {
            this.monitors.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToMonitors(Collection<String> items) {
        if (this.monitors == null) {
            this.monitors = new ArrayList<String>();
        }
        for (String item : items) {
            this.monitors.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromMonitors(String ... items) {
        for (String item : items) {
            if (this.monitors == null) continue;
            this.monitors.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromMonitors(Collection<String> items) {
        for (String item : items) {
            if (this.monitors == null) continue;
            this.monitors.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getMonitors() {
        return this.monitors;
    }

    @Override
    public String getMonitor(int index) {
        return this.monitors.get(index);
    }

    @Override
    public String getFirstMonitor() {
        return this.monitors.get(0);
    }

    @Override
    public String getLastMonitor() {
        return this.monitors.get(this.monitors.size() - 1);
    }

    @Override
    public String getMatchingMonitor(Predicate<String> predicate) {
        for (String item : this.monitors) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingMonitor(Predicate<String> predicate) {
        for (String item : this.monitors) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withMonitors(List<String> monitors) {
        if (this.monitors != null) {
            this._visitables.get("monitors").removeAll(this.monitors);
        }
        if (monitors != null) {
            this.monitors = new ArrayList<String>();
            for (String item : monitors) {
                this.addToMonitors(item);
            }
        } else {
            this.monitors = null;
        }
        return (A)this;
    }

    @Override
    public A withMonitors(String ... monitors) {
        if (this.monitors != null) {
            this.monitors.clear();
        }
        if (monitors != null) {
            for (String item : monitors) {
                this.addToMonitors(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasMonitors() {
        return this.monitors != null && !this.monitors.isEmpty();
    }

    @Override
    public A addNewMonitor(String arg1) {
        return this.addToMonitors(new String(arg1));
    }

    @Override
    public A addNewMonitor(StringBuilder arg1) {
        return this.addToMonitors(new String(arg1));
    }

    @Override
    public A addNewMonitor(StringBuffer arg1) {
        return this.addToMonitors(new String(arg1));
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public A withPath(String path) {
        this.path = path;
        return (A)this;
    }

    @Override
    public Boolean hasPath() {
        return this.path != null;
    }

    @Override
    public A withNewPath(String arg1) {
        return this.withPath(new String(arg1));
    }

    @Override
    public A withNewPath(StringBuilder arg1) {
        return this.withPath(new String(arg1));
    }

    @Override
    public A withNewPath(StringBuffer arg1) {
        return this.withPath(new String(arg1));
    }

    @Override
    public Boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)this;
    }

    @Override
    public Boolean hasReadOnly() {
        return this.readOnly != null;
    }

    @Override
    public A withNewReadOnly(String arg1) {
        return this.withReadOnly(new Boolean(arg1));
    }

    @Override
    public A withNewReadOnly(boolean arg1) {
        return this.withReadOnly(new Boolean(arg1));
    }

    @Override
    public String getSecretFile() {
        return this.secretFile;
    }

    @Override
    public A withSecretFile(String secretFile) {
        this.secretFile = secretFile;
        return (A)this;
    }

    @Override
    public Boolean hasSecretFile() {
        return this.secretFile != null;
    }

    @Override
    public A withNewSecretFile(String arg1) {
        return this.withSecretFile(new String(arg1));
    }

    @Override
    public A withNewSecretFile(StringBuilder arg1) {
        return this.withSecretFile(new String(arg1));
    }

    @Override
    public A withNewSecretFile(StringBuffer arg1) {
        return this.withSecretFile(new String(arg1));
    }

    @Override
    @Deprecated
    public LocalObjectReference getSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public LocalObjectReference buildSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public A withSecretRef(LocalObjectReference secretRef) {
        this._visitables.get("secretRef").remove(this.secretRef);
        if (secretRef != null) {
            this.secretRef = new LocalObjectReferenceBuilder(secretRef);
            this._visitables.get("secretRef").add(this.secretRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecretRef() {
        return this.secretRef != null;
    }

    @Override
    public A withNewSecretRef(String name) {
        return this.withSecretRef(new LocalObjectReference(name));
    }

    @Override
    public CephFSVolumeSourceFluent.SecretRefNested<A> withNewSecretRef() {
        return new SecretRefNestedImpl();
    }

    @Override
    public CephFSVolumeSourceFluent.SecretRefNested<A> withNewSecretRefLike(LocalObjectReference item) {
        return new SecretRefNestedImpl(item);
    }

    @Override
    public CephFSVolumeSourceFluent.SecretRefNested<A> editSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef());
    }

    @Override
    public CephFSVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : new LocalObjectReferenceBuilder().build());
    }

    @Override
    public CephFSVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRefLike(LocalObjectReference item) {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : item);
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public A withUser(String user) {
        this.user = user;
        return (A)this;
    }

    @Override
    public Boolean hasUser() {
        return this.user != null;
    }

    @Override
    public A withNewUser(String arg1) {
        return this.withUser(new String(arg1));
    }

    @Override
    public A withNewUser(StringBuilder arg1) {
        return this.withUser(new String(arg1));
    }

    @Override
    public A withNewUser(StringBuffer arg1) {
        return this.withUser(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CephFSVolumeSourceFluentImpl that = (CephFSVolumeSourceFluentImpl)o;
        if (this.monitors != null ? !this.monitors.equals(that.monitors) : that.monitors != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) {
            return false;
        }
        if (this.secretFile != null ? !this.secretFile.equals(that.secretFile) : that.secretFile != null) {
            return false;
        }
        if (this.secretRef != null ? !this.secretRef.equals(that.secretRef) : that.secretRef != null) {
            return false;
        }
        return !(this.user != null ? !this.user.equals(that.user) : that.user != null);
    }

    public class SecretRefNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<CephFSVolumeSourceFluent.SecretRefNested<N>>
    implements CephFSVolumeSourceFluent.SecretRefNested<N>,
    Nested<N> {
        private final LocalObjectReferenceBuilder builder;

        SecretRefNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        SecretRefNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)CephFSVolumeSourceFluentImpl.this.withSecretRef(this.builder.build());
        }

        @Override
        public N endSecretRef() {
            return this.and();
        }
    }
}

