/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v4_10.handlers;

import io.fabric8.kubernetes.api.model.v4_10.DeletionPropagation;
import io.fabric8.kubernetes.clnt.v4_10.Config;
import io.fabric8.kubernetes.clnt.v4_10.ResourceHandler;
import io.fabric8.kubernetes.clnt.v4_10.Watch;
import io.fabric8.kubernetes.clnt.v4_10.Watcher;
import io.fabric8.kubernetes.clnt.v4_10.dsl.Gettable;
import io.fabric8.openshift.api.model.v4_10.Build;
import io.fabric8.openshift.api.model.v4_10.BuildBuilder;
import io.fabric8.openshift.clnt.v4_10.OpenShiftConfig;
import io.fabric8.openshift.clnt.v4_10.dsl.BuildResource;
import io.fabric8.openshift.clnt.v4_10.dsl.internal.BuildOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class BuildHandler
implements ResourceHandler<Build, BuildBuilder> {
    @Override
    public String getKind() {
        return Build.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "build.openshift.io/v1";
    }

    @Override
    public Build create(OkHttpClient client, Config config, String namespace, Build item) {
        return (Build)new BuildOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create(new Build[0]);
    }

    @Override
    public Build replace(OkHttpClient client, Config config, String namespace, Build item) {
        return (Build)((BuildResource)new BuildOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public Build reload(OkHttpClient client, Config config, String namespace, Build item) {
        return (Build)((Gettable)((BuildResource)new BuildOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public BuildBuilder edit(Build item) {
        return new BuildBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, Build item) {
        return (Boolean)new BuildOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).withPropagationPolicy(propagationPolicy).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Build item, Watcher<Build> watcher) {
        return (Watch)((BuildResource)new BuildOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Build item, String resourceVersion, Watcher<Build> watcher) {
        return (Watch)((BuildResource)new BuildOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Build waitUntilReady(OkHttpClient client, Config config, String namespace, Build item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Build)((BuildResource)new BuildOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public Build waitUntilCondition(OkHttpClient client, Config config, String namespace, Build item, Predicate<Build> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Build)((BuildResource)new BuildOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

