/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_10.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.model.v4_10.AuthInfo;
import io.fabric8.kubernetes.api.model.v4_10.Cluster;
import io.fabric8.kubernetes.api.model.v4_10.Config;
import io.fabric8.kubernetes.api.model.v4_10.Context;
import io.fabric8.kubernetes.api.model.v4_10.NamedAuthInfo;
import io.fabric8.kubernetes.api.model.v4_10.NamedCluster;
import io.fabric8.kubernetes.api.model.v4_10.NamedContext;
import io.fabric8.kubernetes.clnt.v4_10.utils.Serialization;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class KubeConfigUtils {
    public static Config parseConfig(File file) throws IOException {
        ObjectMapper mapper = Serialization.yamlMapper();
        return (Config)mapper.readValue(file, Config.class);
    }

    public static Config parseConfigFromString(String contents) throws IOException {
        ObjectMapper mapper = Serialization.yamlMapper();
        return (Config)mapper.readValue(contents, Config.class);
    }

    public static Context getCurrentContext(Config config) {
        List contexts;
        String contextName = config.getCurrentContext();
        if (contextName != null && (contexts = config.getContexts()) != null) {
            for (NamedContext context : contexts) {
                if (!contextName.equals(context.getName())) continue;
                return context.getContext();
            }
        }
        return null;
    }

    public static String getUserToken(Config config, Context context) {
        AuthInfo authInfo = KubeConfigUtils.getUserAuthInfo(config, context);
        if (authInfo != null) {
            return authInfo.getToken();
        }
        return null;
    }

    public static AuthInfo getUserAuthInfo(Config config, Context context) {
        List users;
        String user;
        AuthInfo authInfo = null;
        if (config != null && context != null && (user = context.getUser()) != null && (users = config.getUsers()) != null) {
            for (NamedAuthInfo namedAuthInfo : users) {
                if (!user.equals(namedAuthInfo.getName())) continue;
                authInfo = namedAuthInfo.getUser();
            }
        }
        return authInfo;
    }

    public static Cluster getCluster(Config config, Context context) {
        List clusters;
        String clusterName;
        Cluster cluster = null;
        if (config != null && context != null && (clusterName = context.getCluster()) != null && (clusters = config.getClusters()) != null) {
            for (NamedCluster namedCluster : clusters) {
                if (!clusterName.equals(namedCluster.getName())) continue;
                cluster = namedCluster.getCluster();
            }
        }
        return cluster;
    }
}

