/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_10.handlers.core.v1;

import io.fabric8.kubernetes.api.model.v4_10.Binding;
import io.fabric8.kubernetes.api.model.v4_10.BindingBuilder;
import io.fabric8.kubernetes.api.model.v4_10.DeletionPropagation;
import io.fabric8.kubernetes.clnt.v4_10.Config;
import io.fabric8.kubernetes.clnt.v4_10.ResourceHandler;
import io.fabric8.kubernetes.clnt.v4_10.Watch;
import io.fabric8.kubernetes.clnt.v4_10.Watcher;
import io.fabric8.kubernetes.clnt.v4_10.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v4_10.dsl.Resource;
import io.fabric8.kubernetes.clnt.v4_10.dsl.internal.core.v1.BindingOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class BindingHandler
implements ResourceHandler<Binding, BindingBuilder> {
    @Override
    public String getKind() {
        return Binding.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "v1";
    }

    @Override
    public Binding create(OkHttpClient client, Config config, String namespace, Binding item) {
        return (Binding)new BindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).create(new Binding[0]);
    }

    @Override
    public Binding replace(OkHttpClient client, Config config, String namespace, Binding item) {
        return (Binding)((Resource)new BindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public Binding reload(OkHttpClient client, Config config, String namespace, Binding item) {
        return (Binding)((Gettable)((Resource)new BindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public BindingBuilder edit(Binding item) {
        return new BindingBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, Binding item) {
        return (Boolean)new BindingOperationsImpl(client, config, namespace).withItem(item).withPropagationPolicy(propagationPolicy).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Binding item, Watcher<Binding> watcher) {
        return (Watch)((Resource)new BindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Binding item, String resourceVersion, Watcher<Binding> watcher) {
        return (Watch)((Resource)new BindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Binding waitUntilReady(OkHttpClient client, Config config, String namespace, Binding item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Binding)((Resource)new BindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public Binding waitUntilCondition(OkHttpClient client, Config config, String namespace, Binding item, Predicate<Binding> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Binding)((Resource)new BindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

