/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_10.handlers.batch.v1;

import io.fabric8.kubernetes.api.model.v4_10.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v4_10.batch.Job;
import io.fabric8.kubernetes.api.model.v4_10.batch.JobBuilder;
import io.fabric8.kubernetes.clnt.v4_10.Config;
import io.fabric8.kubernetes.clnt.v4_10.ResourceHandler;
import io.fabric8.kubernetes.clnt.v4_10.Watch;
import io.fabric8.kubernetes.clnt.v4_10.Watcher;
import io.fabric8.kubernetes.clnt.v4_10.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v4_10.dsl.Resource;
import io.fabric8.kubernetes.clnt.v4_10.dsl.internal.batch.v1.JobOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class JobHandler
implements ResourceHandler<Job, JobBuilder> {
    @Override
    public String getKind() {
        return Job.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "batch/v1";
    }

    @Override
    public Job create(OkHttpClient client, Config config, String namespace, Job item) {
        return (Job)new JobOperationsImpl(client, config).withItem(item).inNamespace(namespace).create(new Job[0]);
    }

    @Override
    public Job replace(OkHttpClient client, Config config, String namespace, Job item) {
        return (Job)((Resource)new JobOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public Job reload(OkHttpClient client, Config config, String namespace, Job item) {
        return (Job)((Gettable)((Resource)new JobOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public JobBuilder edit(Job item) {
        return new JobBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, Job item) {
        return (Boolean)new JobOperationsImpl(client, config, namespace).withItem(item).withPropagationPolicy(propagationPolicy).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Job item, Watcher<Job> watcher) {
        return (Watch)((Resource)new JobOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Job item, String resourceVersion, Watcher<Job> watcher) {
        return (Watch)((Resource)new JobOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Job waitUntilReady(OkHttpClient client, Config config, String namespace, Job item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Job)((Resource)new JobOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public Job waitUntilCondition(OkHttpClient client, Config config, String namespace, Job item, Predicate<Job> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Job)((Resource)new JobOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

