/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_10.dsl.internal;

import io.fabric8.kubernetes.api.builder.v4_10.TypedVisitor;
import io.fabric8.kubernetes.api.builder.v4_10.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.v4_10.Visitor;
import io.fabric8.kubernetes.api.model.v4_10.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v4_10.HasMetadata;
import io.fabric8.kubernetes.api.model.v4_10.KubernetesList;
import io.fabric8.kubernetes.api.model.v4_10.ObjectMetaBuilder;
import io.fabric8.kubernetes.clnt.v4_10.Config;
import io.fabric8.kubernetes.clnt.v4_10.Handlers;
import io.fabric8.kubernetes.clnt.v4_10.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v4_10.ResourceHandler;
import io.fabric8.kubernetes.clnt.v4_10.Watch;
import io.fabric8.kubernetes.clnt.v4_10.Watcher;
import io.fabric8.kubernetes.clnt.v4_10.dsl.Applicable;
import io.fabric8.kubernetes.clnt.v4_10.dsl.CascadingDeletable;
import io.fabric8.kubernetes.clnt.v4_10.dsl.Deletable;
import io.fabric8.kubernetes.clnt.v4_10.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v4_10.dsl.NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v4_10.dsl.Readiable;
import io.fabric8.kubernetes.clnt.v4_10.dsl.VisitFromServerGetWatchDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v4_10.dsl.Waitable;
import io.fabric8.kubernetes.clnt.v4_10.dsl.base.OperationSupport;
import io.fabric8.kubernetes.clnt.v4_10.handlers.KubernetesListHandler;
import io.fabric8.kubernetes.clnt.v4_10.internal.readiness.Readiness;
import io.fabric8.kubernetes.clnt.v4_10.utils.ResourceCompare;
import io.fabric8.kubernetes.clnt.v4_10.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl
extends OperationSupport
implements NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata, Boolean>,
Waitable<HasMetadata, HasMetadata>,
Readiable {
    private static final Logger LOGGER = LoggerFactory.getLogger(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.class);
    private final String fallbackNamespace;
    private final String explicitNamespace;
    private final Boolean fromServer;
    private final Boolean deletingExisting;
    private final List<Visitor> visitors;
    private final Object item;
    private final ResourceHandler handler;
    private final long gracePeriodSeconds;
    private final DeletionPropagation propagationPolicy;
    private final Boolean cascading;

    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(OkHttpClient client, Config config, String namespace, String explicitNamespace, Boolean fromServer, Boolean deletingExisting, List<Visitor> visitors, InputStream is, Boolean cascading) {
        this(client, config, namespace, explicitNamespace, fromServer, deletingExisting, visitors, NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.unmarshal(is), -1L, null, cascading);
    }

    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(OkHttpClient client, Config config, String namespace, String explicitNamespace, Boolean fromServer, Boolean deletingExisting, List<Visitor> visitors, Object item, long gracePeriodSeconds, DeletionPropagation propagationPolicy, Boolean cascading) {
        super(client, config);
        this.fallbackNamespace = namespace;
        this.explicitNamespace = explicitNamespace;
        this.fromServer = fromServer;
        this.deletingExisting = deletingExisting;
        this.visitors = visitors != null ? new ArrayList<Visitor>(visitors) : new ArrayList();
        this.item = item;
        this.handler = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(item);
        this.cascading = cascading;
        if (this.handler == null) {
            throw new KubernetesClientException("No handler found for object:" + item);
        }
        this.gracePeriodSeconds = gracePeriodSeconds;
        this.propagationPolicy = propagationPolicy;
        this.visitors.add((Visitor)new ChangeNamespace(explicitNamespace, this.fallbackNamespace));
    }

    @Override
    public HasMetadata apply() {
        return this.createOrReplace();
    }

    @Override
    public HasMetadata createOrReplace() {
        HasMetadata meta = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.acceptVisitors(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.asHasMetadata(this.item), this.visitors);
        ResourceHandler h = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(meta);
        HasMetadata r = h.reload(this.client, this.config, meta.getMetadata().getNamespace(), meta);
        String namespaceToUse = meta.getMetadata().getNamespace();
        if (r == null) {
            return h.create(this.client, this.config, namespaceToUse, meta);
        }
        if (this.deletingExisting.booleanValue()) {
            Boolean deleted = h.delete(this.client, this.config, namespaceToUse, this.propagationPolicy, meta);
            if (!deleted.booleanValue()) {
                throw new KubernetesClientException("Failed to delete existing item:" + meta);
            }
            return h.create(this.client, this.config, namespaceToUse, meta);
        }
        if (ResourceCompare.equals(r, meta)) {
            LOGGER.debug("Item has not changed. Skipping");
            return meta;
        }
        return h.replace(this.client, this.config, namespaceToUse, meta);
    }

    @Override
    public Waitable<HasMetadata, HasMetadata> createOrReplaceAnd() {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, this.deletingExisting, this.visitors, this.createOrReplace(), this.gracePeriodSeconds, this.propagationPolicy, this.cascading);
    }

    @Override
    public Boolean delete() {
        HasMetadata meta = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.acceptVisitors(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.asHasMetadata(this.item), this.visitors);
        ResourceHandler h = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(meta);
        return h.delete(this.client, this.config, meta.getMetadata().getNamespace(), this.propagationPolicy, meta);
    }

    @Override
    public HasMetadata get() {
        if (this.fromServer.booleanValue()) {
            HasMetadata meta = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.acceptVisitors(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.asHasMetadata(this.item), this.visitors);
            ResourceHandler h = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(meta);
            HasMetadata reloaded = h.reload(this.client, this.config, meta.getMetadata().getNamespace(), meta);
            if (reloaded != null) {
                HasMetadata edited = reloaded;
                for (Visitor v : this.visitors) {
                    edited = (HasMetadata)((VisitableBuilder)h.edit(edited).accept(v)).build();
                }
                return edited;
            }
            return null;
        }
        return NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.acceptVisitors(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.asHasMetadata(this.item), this.visitors);
    }

    @Override
    public VisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata, Boolean> inNamespace(String explicitNamespace) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this.client, this.config, this.fallbackNamespace, explicitNamespace, this.fromServer, this.deletingExisting, this.visitors, this.item, this.gracePeriodSeconds, this.propagationPolicy, this.cascading);
    }

    @Override
    public Gettable<HasMetadata> fromServer() {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, true, this.deletingExisting, this.visitors, this.item, this.gracePeriodSeconds, this.propagationPolicy, this.cascading);
    }

    @Override
    public Applicable<HasMetadata> deletingExisting() {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, true, this.visitors, this.item, this.gracePeriodSeconds, this.propagationPolicy, this.cascading);
    }

    public VisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata, Boolean> accept(Visitor visitor) {
        ArrayList<Visitor> newVisitors = new ArrayList<Visitor>(this.visitors);
        newVisitors.add(visitor);
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, true, newVisitors, this.item, this.gracePeriodSeconds, this.propagationPolicy, this.cascading);
    }

    @Override
    public CascadingDeletable<Boolean> withGracePeriod(long gracePeriodSeconds) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, true, this.visitors, this.item, gracePeriodSeconds, this.propagationPolicy, this.cascading);
    }

    @Override
    public CascadingDeletable<Boolean> withPropagationPolicy(DeletionPropagation propagationPolicy) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, true, this.visitors, this.item, this.gracePeriodSeconds, propagationPolicy, this.cascading);
    }

    @Override
    public Deletable<Boolean> cascading(boolean cascading) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, true, this.visitors, this.item, this.gracePeriodSeconds, this.propagationPolicy, cascading);
    }

    @Override
    public Watch watch(Watcher<HasMetadata> watcher) {
        HasMetadata meta = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.acceptVisitors(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.asHasMetadata(this.item), this.visitors);
        ResourceHandler h = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(meta);
        return h.watch(this.client, this.config, meta.getMetadata().getNamespace(), meta, watcher);
    }

    @Override
    public Watch watch(String resourceVersion, Watcher<HasMetadata> watcher) {
        HasMetadata meta = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.acceptVisitors(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.asHasMetadata(this.item), this.visitors);
        ResourceHandler h = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(meta);
        return h.watch(this.client, this.config, meta.getMetadata().getNamespace(), meta, watcher);
    }

    @Override
    public Boolean isReady() {
        return Readiness.isReady(this.get());
    }

    @Override
    public HasMetadata waitUntilReady(long amount, TimeUnit timeUnit) throws InterruptedException {
        HasMetadata meta = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.acceptVisitors(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.asHasMetadata(this.get()), this.visitors);
        ResourceHandler h = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(meta);
        return h.waitUntilReady(this.client, this.config, meta.getMetadata().getNamespace(), meta, amount, timeUnit);
    }

    @Override
    public HasMetadata waitUntilCondition(Predicate<HasMetadata> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        HasMetadata meta = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.acceptVisitors(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.asHasMetadata(this.get()), this.visitors);
        ResourceHandler h = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(meta);
        return h.waitUntilCondition(this.client, this.config, meta.getMetadata().getNamespace(), meta, condition, amount, timeUnit);
    }

    private static HasMetadata acceptVisitors(HasMetadata item, List<Visitor> visitors) {
        ResourceHandler h = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(item);
        Object builder = h.edit(item);
        for (Visitor v : visitors) {
            builder.accept(v);
        }
        return (HasMetadata)builder.build();
    }

    private static List<HasMetadata> acceptVisitors(List<HasMetadata> list, List<Visitor> visitors) {
        ArrayList<HasMetadata> result = new ArrayList<HasMetadata>();
        for (HasMetadata item : list) {
            ResourceHandler h = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(item);
            Object builder = h.edit(item);
            for (Visitor v : visitors) {
                builder.accept(v);
            }
            result.add((HasMetadata)builder.build());
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> HasMetadata asHasMetadata(T item) {
        if (item instanceof HasMetadata) {
            return (HasMetadata)item;
        }
        if (!(item instanceof String)) throw new IllegalArgumentException("Item needs to be an instance of HasMetadata or String.");
        try (ByteArrayInputStream is = new ByteArrayInputStream(((String)item).getBytes(StandardCharsets.UTF_8));){
            HasMetadata hasMetadata = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.asHasMetadata(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.unmarshal(is));
            return hasMetadata;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    private static <T> ResourceHandler handlerOf(T item) {
        if (item instanceof HasMetadata) {
            return Handlers.get(((HasMetadata)item).getKind(), ((HasMetadata)item).getApiVersion());
        }
        if (item instanceof KubernetesList) {
            return new KubernetesListHandler();
        }
        throw new IllegalArgumentException("Could not find a registered handler for item: [" + item + "].");
    }

    private class ChangeNamespace
    extends TypedVisitor<ObjectMetaBuilder> {
        private final String explicitNamespace;
        private final String fallbackNamespace;

        private ChangeNamespace(String explicitNamespace, String fallbackNamespace) {
            this.explicitNamespace = explicitNamespace;
            this.fallbackNamespace = fallbackNamespace;
        }

        public void visit(ObjectMetaBuilder builder) {
            if (Utils.isNotNullOrEmpty(this.explicitNamespace)) {
                builder.withNamespace(this.explicitNamespace);
            } else if (Utils.isNullOrEmpty(builder.getNamespace())) {
                builder.withNamespace(this.fallbackNamespace);
            }
        }
    }
}

