/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_10.dsl.internal;

import io.fabric8.kubernetes.api.model.v4_10.Doneable;
import io.fabric8.kubernetes.api.model.v4_10.HasMetadata;
import io.fabric8.kubernetes.api.model.v4_10.KubernetesResource;
import io.fabric8.kubernetes.api.model.v4_10.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.v4_10.apiextensions.CustomResourceDefinition;
import io.fabric8.kubernetes.clnt.v4_10.Config;
import io.fabric8.kubernetes.clnt.v4_10.dsl.MixedOperation;
import io.fabric8.kubernetes.clnt.v4_10.dsl.Resource;
import io.fabric8.kubernetes.clnt.v4_10.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.clnt.v4_10.dsl.base.OperationContext;
import io.fabric8.kubernetes.clnt.v4_10.dsl.internal.CustomResourceOperationContext;
import io.fabric8.kubernetes.clnt.v4_10.internal.KubernetesDeserializer;
import okhttp3.OkHttpClient;

public class CustomResourceOperationsImpl<T extends HasMetadata, L extends KubernetesResourceList, D extends Doneable<T>>
extends HasMetadataOperation<T, L, D, Resource<T, D>>
implements MixedOperation<T, L, D, Resource<T, D>> {
    private final boolean resourceNamespaced;

    public CustomResourceOperationsImpl(OkHttpClient client, Config config) {
        this(new CustomResourceOperationContext().withOkhttpClient(client).withConfig(config));
    }

    public CustomResourceOperationsImpl(CustomResourceOperationContext context) {
        super(context.withApiGroupName(CustomResourceOperationsImpl.apiGroup((CustomResourceDefinition)context.getCrd())).withApiGroupVersion(CustomResourceOperationsImpl.apiVersion((CustomResourceDefinition)context.getCrd())).withPlural(CustomResourceOperationsImpl.resourceT((CustomResourceDefinition)context.getCrd())).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
        this.type = context.getType();
        this.listType = context.getListType();
        this.doneableType = context.getDoneableType();
        this.resourceNamespaced = CustomResourceOperationsImpl.resourceNamespaced((CustomResourceDefinition)context.getCrd());
        this.apiVersion = this.getAPIGroup() + "/" + this.getAPIVersion();
        CustomResourceDefinition crd = (CustomResourceDefinition)context.getCrd();
        KubernetesDeserializer.registerCustomKind((String)(crd.getSpec().getGroup() + "/" + crd.getSpec().getVersion()), (String)crd.getSpec().getNames().getKind(), (Class)this.type);
        if (KubernetesResource.class.isAssignableFrom(this.listType)) {
            KubernetesDeserializer.registerCustomKind((String)this.listType.getSimpleName(), (Class)this.listType);
        }
    }

    public CustomResourceOperationsImpl newInstance(OperationContext context) {
        return new CustomResourceOperationsImpl<T, L, D>((CustomResourceOperationContext)context);
    }

    protected static String apiGroup(CustomResourceDefinition crd) {
        return crd.getSpec().getGroup();
    }

    protected static String apiVersion(CustomResourceDefinition crd) {
        return crd.getSpec().getVersion();
    }

    protected static String resourceT(CustomResourceDefinition crd) {
        return crd.getSpec().getNames().getPlural();
    }

    protected static String name(CustomResourceDefinition crd) {
        return crd.getMetadata().getName();
    }

    protected static boolean resourceNamespaced(CustomResourceDefinition crd) {
        return "Namespaced".equals(crd.getSpec().getScope());
    }

    @Override
    public boolean isResourceNamespaced() {
        return this.resourceNamespaced;
    }
}

