/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.ConfigAndApiGroupsInfo;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.utils.URLUtils;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.OpenShiftConfig;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import okhttp3.OkHttpClient;

public class OpenShiftOperation<T extends HasMetadata, L extends KubernetesResourceList, D extends Doneable<T>, R extends Resource<T, D>>
extends HasMetadataOperation<T, L, D, R> {
    protected OpenShiftOperation(OkHttpClient client, ConfigAndApiGroupsInfo config, String resourceT, String namespace, String name, Boolean cascading, T item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields) {
        super(client, config.getConfig(), config.getApiGroupName(), config.getApiGroupVersion(), resourceT, namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields);
        this.apiVersion = config.getApiGroupVersion();
    }

    public static ConfigAndApiGroupsInfo withApiGroup(OpenShiftClient openShiftClient, String apiGroupName, String apiVersion, OpenShiftConfig config) {
        String oapiVersion = config.getOapiVersion();
        if (config.isOpenShiftAPIGroups(openShiftClient)) {
            String apiGroupUrl = URLUtils.join(config.getMasterUrl(), "apis", apiGroupName, oapiVersion);
            String apiGroupVersion = URLUtils.join(apiGroupName, oapiVersion);
            return new ConfigAndApiGroupsInfo(new OpenShiftConfig(config, apiGroupUrl), apiGroupName, apiGroupVersion);
        }
        if (apiVersion == null) {
            apiVersion = oapiVersion;
        }
        return new ConfigAndApiGroupsInfo(config, apiGroupName, apiVersion);
    }

    public static ConfigAndApiGroupsInfo withApiGroup(OkHttpClient httpClient, String apiGroupName, String apiVersion, OpenShiftConfig config) {
        DefaultOpenShiftClient openShiftClient = new DefaultOpenShiftClient(httpClient, config);
        return OpenShiftOperation.withApiGroup(openShiftClient, apiGroupName, apiVersion, config);
    }

    @Override
    public URL getRootUrl() {
        try {
            return new URL(OpenShiftConfig.wrap(this.getConfig()).getOpenShiftUrl());
        }
        catch (MalformedURLException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public OpenShiftConfig getConfig() {
        return OpenShiftConfig.wrap(super.getConfig());
    }

    @Override
    protected Class<? extends Config> getConfigType() {
        return OpenShiftConfig.class;
    }
}

