/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v4_1;

import io.fabric8.kubernetes.api.builder.v4_1.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_1.VisitableBuilder;
import io.fabric8.openshift.api.model.v4_1.DeploymentConfigList;
import io.fabric8.openshift.api.model.v4_1.DeploymentConfigListFluent;
import io.fabric8.openshift.api.model.v4_1.DeploymentConfigListFluentImpl;
import javax.validation.Validator;

public class DeploymentConfigListBuilder
extends DeploymentConfigListFluentImpl<DeploymentConfigListBuilder>
implements VisitableBuilder<DeploymentConfigList, DeploymentConfigListBuilder> {
    DeploymentConfigListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public DeploymentConfigListBuilder() {
        this(true);
    }

    public DeploymentConfigListBuilder(Boolean validationEnabled) {
        this(new DeploymentConfigList(), validationEnabled);
    }

    public DeploymentConfigListBuilder(DeploymentConfigListFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public DeploymentConfigListBuilder(DeploymentConfigListFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new DeploymentConfigList(), validationEnabled);
    }

    public DeploymentConfigListBuilder(DeploymentConfigListFluent<?> fluent, DeploymentConfigList instance) {
        this(fluent, instance, true);
    }

    public DeploymentConfigListBuilder(DeploymentConfigListFluent<?> fluent, DeploymentConfigList instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public DeploymentConfigListBuilder(DeploymentConfigList instance) {
        this(instance, (Boolean)true);
    }

    public DeploymentConfigListBuilder(DeploymentConfigList instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public DeploymentConfigListBuilder(Validator validator) {
        this(new DeploymentConfigList(), (Boolean)true);
    }

    public DeploymentConfigListBuilder(DeploymentConfigListFluent<?> fluent, DeploymentConfigList instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public DeploymentConfigListBuilder(DeploymentConfigList instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public DeploymentConfigList build() {
        DeploymentConfigList buildable = new DeploymentConfigList(this.fluent.getApiVersion(), this.fluent.getItems(), this.fluent.getKind(), this.fluent.getMetadata());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeploymentConfigListBuilder that = (DeploymentConfigListBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

