/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_1.dsl.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.fabric8.kubernetes.api.model.v4_1.Doneable;
import io.fabric8.kubernetes.api.model.v4_1.DoneablePod;
import io.fabric8.kubernetes.api.model.v4_1.HasMetadata;
import io.fabric8.kubernetes.api.model.v4_1.Pod;
import io.fabric8.kubernetes.api.model.v4_1.PodCondition;
import io.fabric8.kubernetes.api.model.v4_1.PodFluent;
import io.fabric8.kubernetes.api.model.v4_1.PodList;
import io.fabric8.kubernetes.clnt.v4_1.Config;
import io.fabric8.kubernetes.clnt.v4_1.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v4_1.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.clnt.v4_1.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v4_1.dsl.Operation;
import io.fabric8.kubernetes.clnt.v4_1.dsl.PodResource;
import io.fabric8.kubernetes.clnt.v4_1.dsl.RollableScalableResource;
import io.fabric8.kubernetes.clnt.v4_1.dsl.internal.PodOperationsImpl;
import io.fabric8.kubernetes.clnt.v4_1.internal.SerializationUtils;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class RollingUpdater<T extends HasMetadata, L, D extends Doneable<T>> {
    static final String DEPLOYMENT_KEY = "deployment";
    private static final Long DEFAULT_ROLLING_TIMEOUT = 900000L;
    private static final Long DEFAULT_SERVER_GC_WAIT_TIMEOUT = 60000L;
    private static final transient Logger LOG = LoggerFactory.getLogger(RollingUpdater.class);
    protected final OkHttpClient client;
    protected final Config config;
    protected final String namespace;
    private final long rollingTimeoutMillis;
    private final long loggingIntervalMillis;

    RollingUpdater(OkHttpClient client, Config config, String namespace) {
        this(client, config, namespace, DEFAULT_ROLLING_TIMEOUT, 20000L);
    }

    RollingUpdater(OkHttpClient client, Config config, String namespace, long rollingTimeoutMillis, long loggingIntervalMillis) {
        this.client = client;
        this.config = config;
        this.namespace = namespace;
        this.rollingTimeoutMillis = rollingTimeoutMillis;
        this.loggingIntervalMillis = loggingIntervalMillis;
    }

    protected abstract T createClone(T var1, String var2, String var3);

    protected abstract PodList listSelectedPods(T var1);

    protected abstract void updateDeploymentKey(D var1, String var2);

    protected abstract void removeDeploymentKey(D var1);

    protected abstract int getReplicas(T var1);

    protected abstract T setReplicas(T var1, int var2);

    T rollUpdate(T oldObj, T newObj) {
        try {
            String namespace = oldObj.getMetadata().getNamespace();
            String oldName = oldObj.getMetadata().getName();
            String oldDeploymentHash = this.md5sum((HasMetadata)oldObj);
            PodList oldPods = this.listSelectedPods(oldObj);
            for (Pod pod : oldPods.getItems()) {
                try {
                    ((DoneablePod)((PodFluent.MetadataNested)((DoneablePod)((PodResource)((NonNamespaceOperation)this.pods().inNamespace(namespace)).withName(pod.getMetadata().getName())).edit()).editMetadata().addToLabels(DEPLOYMENT_KEY, oldDeploymentHash)).and()).done();
                }
                catch (KubernetesClientException e) {
                    LOG.warn("Unable to add deployment key to pod: {}", (Object)e.getMessage());
                }
            }
            Doneable editable = (Doneable)((EditReplacePatchDeletable)((RollableScalableResource)((NonNamespaceOperation)this.resources().inNamespace(namespace)).withName(oldName)).cascading(false)).edit();
            this.updateDeploymentKey(editable, oldDeploymentHash);
            oldObj = (HasMetadata)editable.done();
            String newDeploymentHash = this.md5sum((HasMetadata)newObj);
            String newName = newObj.getMetadata().getName();
            if (newName == null || newName.equals(oldName)) {
                newName = newName + "-" + newDeploymentHash;
            }
            T clonedObj = this.createClone(newObj, newName, newDeploymentHash);
            HasMetadata createdObj = (HasMetadata)((NonNamespaceOperation)this.resources().inNamespace(namespace)).create(clonedObj);
            int oldReplicas = this.getReplicas(oldObj);
            while (this.getReplicas(createdObj) < this.getReplicas(newObj)) {
                int newReplicas = this.getReplicas(createdObj) + 1;
                ((RollableScalableResource)((NonNamespaceOperation)this.resources().inNamespace(namespace)).withName(createdObj.getMetadata().getName())).scale(newReplicas, true);
                this.waitUntilPodsAreReady(createdObj, namespace, newReplicas);
                createdObj = this.setReplicas(createdObj, newReplicas);
                if (oldReplicas <= 0) continue;
                ((RollableScalableResource)((NonNamespaceOperation)this.resources().inNamespace(namespace)).withName(oldName)).scale(--oldReplicas, true);
                this.waitUntilPodsAreReady(oldObj, namespace, oldReplicas);
            }
            ((RollableScalableResource)((NonNamespaceOperation)this.resources().inNamespace(namespace)).withName(oldName)).delete();
            if (Objects.equals(oldName, newObj.getMetadata().getName())) {
                ((EditReplacePatchDeletable)((RollableScalableResource)((NonNamespaceOperation)this.resources().inNamespace(namespace)).withName(newName)).cascading(false)).delete();
                this.waitUntilDeleted(namespace, newName);
                createdObj.getMetadata().setResourceVersion(null);
                createdObj.getMetadata().setName(oldName);
                createdObj = (HasMetadata)((NonNamespaceOperation)this.resources().inNamespace(namespace)).create(createdObj);
                editable = (Doneable)((EditReplacePatchDeletable)((RollableScalableResource)((NonNamespaceOperation)this.resources().inNamespace(namespace)).withName(createdObj.getMetadata().getName())).cascading(false)).edit();
                this.removeDeploymentKey(editable);
                createdObj = (HasMetadata)editable.done();
            }
            return (T)createdObj;
        }
        catch (JsonProcessingException | NoSuchAlgorithmException e) {
            throw new KubernetesClientException("Could not calculate MD5 of RC", e);
        }
    }

    private void waitUntilPodsAreReady(T obj, String namespace, int requiredPodCount) {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        AtomicInteger podCount = new AtomicInteger(0);
        Runnable readyPodsPoller = () -> {
            PodList podList = this.listSelectedPods(obj);
            int count = 0;
            List<Pod> items = podList.getItems();
            for (Pod item : items) {
                for (PodCondition c : item.getStatus().getConditions()) {
                    if (!c.getType().equals("Ready") || !c.getStatus().equals("True")) continue;
                    ++count;
                }
            }
            podCount.set(count);
            if (count == requiredPodCount) {
                countDownLatch.countDown();
            }
        };
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        ScheduledFuture<?> poller = executor.scheduleWithFixedDelay(readyPodsPoller, 0L, 1L, TimeUnit.SECONDS);
        ScheduledFuture<?> logger = executor.scheduleWithFixedDelay(() -> LOG.debug("Only {}/{} pod(s) ready for {}: {} in namespace: {} seconds so waiting...", new Object[]{podCount.get(), requiredPodCount, obj.getKind(), obj.getMetadata().getName(), namespace}), 0L, this.loggingIntervalMillis, TimeUnit.MILLISECONDS);
        try {
            countDownLatch.await(this.rollingTimeoutMillis, TimeUnit.MILLISECONDS);
            executor.shutdown();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            poller.cancel(true);
            logger.cancel(true);
            executor.shutdown();
            LOG.warn("Only {}/{} pod(s) ready for {}: {} in namespace: {}  after waiting for {} seconds so giving up", new Object[]{podCount.get(), requiredPodCount, obj.getKind(), obj.getMetadata().getName(), namespace, TimeUnit.MILLISECONDS.toSeconds(this.rollingTimeoutMillis)});
        }
    }

    private void waitUntilDeleted(String namespace, String name) {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Runnable waitTillDeletedPoller = () -> {
            block3: {
                try {
                    HasMetadata res = (HasMetadata)((RollableScalableResource)((NonNamespaceOperation)this.resources().inNamespace(namespace)).withName(name)).get();
                    if (res == null) {
                        countDownLatch.countDown();
                    }
                }
                catch (KubernetesClientException e) {
                    if (e.getCode() != 404) break block3;
                    countDownLatch.countDown();
                }
            }
        };
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        ScheduledFuture<?> poller = executor.scheduleWithFixedDelay(waitTillDeletedPoller, 0L, 5L, TimeUnit.SECONDS);
        ScheduledFuture<?> logger = executor.scheduleWithFixedDelay(() -> LOG.debug("Found resource {}/{} not yet deleted on server, so waiting...", (Object)namespace, (Object)name), 0L, this.loggingIntervalMillis, TimeUnit.MILLISECONDS);
        try {
            countDownLatch.await(DEFAULT_SERVER_GC_WAIT_TIMEOUT, TimeUnit.MILLISECONDS);
            executor.shutdown();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            poller.cancel(true);
            logger.cancel(true);
            executor.shutdown();
            LOG.warn("Still found deleted resource {} in namespace: {}  after waiting for {} seconds so giving up", new Object[]{name, namespace, TimeUnit.MILLISECONDS.toSeconds(DEFAULT_SERVER_GC_WAIT_TIMEOUT)});
        }
    }

    private String md5sum(HasMetadata obj) throws NoSuchAlgorithmException, JsonProcessingException {
        byte[] digest = MessageDigest.getInstance("MD5").digest(SerializationUtils.dumpWithoutRuntimeStateAsYaml(obj).getBytes());
        BigInteger i = new BigInteger(1, digest);
        return String.format("%1$032x", i);
    }

    protected abstract Operation<T, L, D, RollableScalableResource<T, D>> resources();

    protected Operation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> pods() {
        return new PodOperationsImpl(this.client, this.config, this.namespace);
    }
}

