/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_1.extensions;

import io.fabric8.kubernetes.api.builder.v4_1.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_1.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_1.extensions.FSGroupStrategyOptions;
import io.fabric8.kubernetes.api.model.v4_1.extensions.FSGroupStrategyOptionsFluent;
import io.fabric8.kubernetes.api.model.v4_1.extensions.FSGroupStrategyOptionsFluentImpl;
import javax.validation.Validator;

public class FSGroupStrategyOptionsBuilder
extends FSGroupStrategyOptionsFluentImpl<FSGroupStrategyOptionsBuilder>
implements VisitableBuilder<FSGroupStrategyOptions, FSGroupStrategyOptionsBuilder> {
    FSGroupStrategyOptionsFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public FSGroupStrategyOptionsBuilder() {
        this(true);
    }

    public FSGroupStrategyOptionsBuilder(Boolean validationEnabled) {
        this(new FSGroupStrategyOptions(), validationEnabled);
    }

    public FSGroupStrategyOptionsBuilder(FSGroupStrategyOptionsFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public FSGroupStrategyOptionsBuilder(FSGroupStrategyOptionsFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new FSGroupStrategyOptions(), validationEnabled);
    }

    public FSGroupStrategyOptionsBuilder(FSGroupStrategyOptionsFluent<?> fluent, FSGroupStrategyOptions instance) {
        this(fluent, instance, true);
    }

    public FSGroupStrategyOptionsBuilder(FSGroupStrategyOptionsFluent<?> fluent, FSGroupStrategyOptions instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withRanges(instance.getRanges());
        fluent.withRule(instance.getRule());
        this.validationEnabled = validationEnabled;
    }

    public FSGroupStrategyOptionsBuilder(FSGroupStrategyOptions instance) {
        this(instance, (Boolean)true);
    }

    public FSGroupStrategyOptionsBuilder(FSGroupStrategyOptions instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withRanges(instance.getRanges());
        this.withRule(instance.getRule());
        this.validationEnabled = validationEnabled;
    }

    public FSGroupStrategyOptionsBuilder(Validator validator) {
        this(new FSGroupStrategyOptions(), (Boolean)true);
    }

    public FSGroupStrategyOptionsBuilder(FSGroupStrategyOptionsFluent<?> fluent, FSGroupStrategyOptions instance, Validator validator) {
        this.fluent = fluent;
        fluent.withRanges(instance.getRanges());
        fluent.withRule(instance.getRule());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public FSGroupStrategyOptionsBuilder(FSGroupStrategyOptions instance, Validator validator) {
        this.fluent = this;
        this.withRanges(instance.getRanges());
        this.withRule(instance.getRule());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public FSGroupStrategyOptions build() {
        FSGroupStrategyOptions buildable = new FSGroupStrategyOptions(this.fluent.getRanges(), this.fluent.getRule());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FSGroupStrategyOptionsBuilder that = (FSGroupStrategyOptionsBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

