/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_1.apiextensions;

import io.fabric8.kubernetes.api.builder.v4_1.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_1.Nested;
import io.fabric8.kubernetes.api.model.v4_1.apiextensions.ServiceReference;
import io.fabric8.kubernetes.api.model.v4_1.apiextensions.ServiceReferenceBuilder;
import io.fabric8.kubernetes.api.model.v4_1.apiextensions.ServiceReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.v4_1.apiextensions.WebhookClientConfig;
import io.fabric8.kubernetes.api.model.v4_1.apiextensions.WebhookClientConfigFluent;

public class WebhookClientConfigFluentImpl<A extends WebhookClientConfigFluent<A>>
extends BaseFluent<A>
implements WebhookClientConfigFluent<A> {
    private String caBundle;
    private ServiceReferenceBuilder service;
    private String url;

    public WebhookClientConfigFluentImpl() {
    }

    public WebhookClientConfigFluentImpl(WebhookClientConfig instance) {
        this.withCaBundle(instance.getCaBundle());
        this.withService(instance.getService());
        this.withUrl(instance.getUrl());
    }

    @Override
    public String getCaBundle() {
        return this.caBundle;
    }

    @Override
    public A withCaBundle(String caBundle) {
        this.caBundle = caBundle;
        return (A)this;
    }

    @Override
    public Boolean hasCaBundle() {
        return this.caBundle != null;
    }

    @Override
    @Deprecated
    public ServiceReference getService() {
        return this.service != null ? this.service.build() : null;
    }

    @Override
    public ServiceReference buildService() {
        return this.service != null ? this.service.build() : null;
    }

    @Override
    public A withService(ServiceReference service) {
        this._visitables.remove(this.service);
        if (service != null) {
            this.service = new ServiceReferenceBuilder(service);
            this._visitables.add(this.service);
        }
        return (A)this;
    }

    @Override
    public Boolean hasService() {
        return this.service != null;
    }

    @Override
    public A withNewService(String name, String namespace, String path) {
        return this.withService(new ServiceReference(name, namespace, path));
    }

    @Override
    public WebhookClientConfigFluent.ServiceNested<A> withNewService() {
        return new ServiceNestedImpl();
    }

    @Override
    public WebhookClientConfigFluent.ServiceNested<A> withNewServiceLike(ServiceReference item) {
        return new ServiceNestedImpl(item);
    }

    @Override
    public WebhookClientConfigFluent.ServiceNested<A> editService() {
        return this.withNewServiceLike(this.getService());
    }

    @Override
    public WebhookClientConfigFluent.ServiceNested<A> editOrNewService() {
        return this.withNewServiceLike(this.getService() != null ? this.getService() : new ServiceReferenceBuilder().build());
    }

    @Override
    public WebhookClientConfigFluent.ServiceNested<A> editOrNewServiceLike(ServiceReference item) {
        return this.withNewServiceLike(this.getService() != null ? this.getService() : item);
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public A withUrl(String url) {
        this.url = url;
        return (A)this;
    }

    @Override
    public Boolean hasUrl() {
        return this.url != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WebhookClientConfigFluentImpl that = (WebhookClientConfigFluentImpl)o;
        if (this.caBundle != null ? !this.caBundle.equals(that.caBundle) : that.caBundle != null) {
            return false;
        }
        if (this.service != null ? !this.service.equals(that.service) : that.service != null) {
            return false;
        }
        return !(this.url != null ? !this.url.equals(that.url) : that.url != null);
    }

    public class ServiceNestedImpl<N>
    extends ServiceReferenceFluentImpl<WebhookClientConfigFluent.ServiceNested<N>>
    implements WebhookClientConfigFluent.ServiceNested<N>,
    Nested<N> {
        private final ServiceReferenceBuilder builder;

        ServiceNestedImpl(ServiceReference item) {
            this.builder = new ServiceReferenceBuilder(this, item);
        }

        ServiceNestedImpl() {
            this.builder = new ServiceReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)WebhookClientConfigFluentImpl.this.withService(this.builder.build());
        }

        @Override
        public N endService() {
            return this.and();
        }
    }
}

