/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_1.apiextensions;

import io.fabric8.kubernetes.api.builder.v4_1.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_1.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_1.apiextensions.ExternalDocumentation;
import io.fabric8.kubernetes.api.model.v4_1.apiextensions.ExternalDocumentationFluent;
import io.fabric8.kubernetes.api.model.v4_1.apiextensions.ExternalDocumentationFluentImpl;
import javax.validation.Validator;

public class ExternalDocumentationBuilder
extends ExternalDocumentationFluentImpl<ExternalDocumentationBuilder>
implements VisitableBuilder<ExternalDocumentation, ExternalDocumentationBuilder> {
    ExternalDocumentationFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ExternalDocumentationBuilder() {
        this(true);
    }

    public ExternalDocumentationBuilder(Boolean validationEnabled) {
        this(new ExternalDocumentation(), validationEnabled);
    }

    public ExternalDocumentationBuilder(ExternalDocumentationFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ExternalDocumentationBuilder(ExternalDocumentationFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ExternalDocumentation(), validationEnabled);
    }

    public ExternalDocumentationBuilder(ExternalDocumentationFluent<?> fluent, ExternalDocumentation instance) {
        this(fluent, instance, true);
    }

    public ExternalDocumentationBuilder(ExternalDocumentationFluent<?> fluent, ExternalDocumentation instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withDescription(instance.getDescription());
        fluent.withUrl(instance.getUrl());
        this.validationEnabled = validationEnabled;
    }

    public ExternalDocumentationBuilder(ExternalDocumentation instance) {
        this(instance, (Boolean)true);
    }

    public ExternalDocumentationBuilder(ExternalDocumentation instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withDescription(instance.getDescription());
        this.withUrl(instance.getUrl());
        this.validationEnabled = validationEnabled;
    }

    public ExternalDocumentationBuilder(Validator validator) {
        this(new ExternalDocumentation(), (Boolean)true);
    }

    public ExternalDocumentationBuilder(ExternalDocumentationFluent<?> fluent, ExternalDocumentation instance, Validator validator) {
        this.fluent = fluent;
        fluent.withDescription(instance.getDescription());
        fluent.withUrl(instance.getUrl());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ExternalDocumentationBuilder(ExternalDocumentation instance, Validator validator) {
        this.fluent = this;
        this.withDescription(instance.getDescription());
        this.withUrl(instance.getUrl());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public ExternalDocumentation build() {
        ExternalDocumentation buildable = new ExternalDocumentation(this.fluent.getDescription(), this.fluent.getUrl());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExternalDocumentationBuilder that = (ExternalDocumentationBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

