/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_1;

import io.fabric8.kubernetes.api.builder.v4_1.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_1.Nested;
import io.fabric8.kubernetes.api.builder.v4_1.Predicate;
import io.fabric8.kubernetes.api.model.v4_1.Quantity;
import io.fabric8.kubernetes.api.model.v4_1.ResourceQuotaSpec;
import io.fabric8.kubernetes.api.model.v4_1.ResourceQuotaSpecFluent;
import io.fabric8.kubernetes.api.model.v4_1.ScopeSelector;
import io.fabric8.kubernetes.api.model.v4_1.ScopeSelectorBuilder;
import io.fabric8.kubernetes.api.model.v4_1.ScopeSelectorFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ResourceQuotaSpecFluentImpl<A extends ResourceQuotaSpecFluent<A>>
extends BaseFluent<A>
implements ResourceQuotaSpecFluent<A> {
    private Map<String, Quantity> hard;
    private ScopeSelectorBuilder scopeSelector;
    private List<String> scopes;

    public ResourceQuotaSpecFluentImpl() {
    }

    public ResourceQuotaSpecFluentImpl(ResourceQuotaSpec instance) {
        this.withHard(instance.getHard());
        this.withScopeSelector(instance.getScopeSelector());
        this.withScopes(instance.getScopes());
    }

    @Override
    public A addToHard(String key, Quantity value) {
        if (this.hard == null && key != null && value != null) {
            this.hard = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.hard.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToHard(Map<String, Quantity> map) {
        if (this.hard == null && map != null) {
            this.hard = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.hard.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromHard(String key) {
        if (this.hard == null) {
            return (A)this;
        }
        if (key != null && this.hard != null) {
            this.hard.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromHard(Map<String, Quantity> map) {
        if (this.hard == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.hard == null) continue;
                this.hard.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Quantity> getHard() {
        return this.hard;
    }

    @Override
    public A withHard(Map<String, Quantity> hard) {
        this.hard = hard == null ? new LinkedHashMap<String, Quantity>() : new LinkedHashMap<String, Quantity>(hard);
        return (A)this;
    }

    @Override
    public Boolean hasHard() {
        return this.hard != null;
    }

    @Override
    @Deprecated
    public ScopeSelector getScopeSelector() {
        return this.scopeSelector != null ? this.scopeSelector.build() : null;
    }

    @Override
    public ScopeSelector buildScopeSelector() {
        return this.scopeSelector != null ? this.scopeSelector.build() : null;
    }

    @Override
    public A withScopeSelector(ScopeSelector scopeSelector) {
        this._visitables.remove(this.scopeSelector);
        if (scopeSelector != null) {
            this.scopeSelector = new ScopeSelectorBuilder(scopeSelector);
            this._visitables.add(this.scopeSelector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasScopeSelector() {
        return this.scopeSelector != null;
    }

    @Override
    public ResourceQuotaSpecFluent.ScopeSelectorNested<A> withNewScopeSelector() {
        return new ScopeSelectorNestedImpl();
    }

    @Override
    public ResourceQuotaSpecFluent.ScopeSelectorNested<A> withNewScopeSelectorLike(ScopeSelector item) {
        return new ScopeSelectorNestedImpl(item);
    }

    @Override
    public ResourceQuotaSpecFluent.ScopeSelectorNested<A> editScopeSelector() {
        return this.withNewScopeSelectorLike(this.getScopeSelector());
    }

    @Override
    public ResourceQuotaSpecFluent.ScopeSelectorNested<A> editOrNewScopeSelector() {
        return this.withNewScopeSelectorLike(this.getScopeSelector() != null ? this.getScopeSelector() : new ScopeSelectorBuilder().build());
    }

    @Override
    public ResourceQuotaSpecFluent.ScopeSelectorNested<A> editOrNewScopeSelectorLike(ScopeSelector item) {
        return this.withNewScopeSelectorLike(this.getScopeSelector() != null ? this.getScopeSelector() : item);
    }

    @Override
    public A addToScopes(int index, String item) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.add(index, item);
        return (A)this;
    }

    @Override
    public A setToScopes(int index, String item) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.set(index, item);
        return (A)this;
    }

    @Override
    public A addToScopes(String ... items) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        for (String item : items) {
            this.scopes.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToScopes(Collection<String> items) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        for (String item : items) {
            this.scopes.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromScopes(String ... items) {
        for (String item : items) {
            if (this.scopes == null) continue;
            this.scopes.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromScopes(Collection<String> items) {
        for (String item : items) {
            if (this.scopes == null) continue;
            this.scopes.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getScopes() {
        return this.scopes;
    }

    @Override
    public String getScope(int index) {
        return this.scopes.get(index);
    }

    @Override
    public String getFirstScope() {
        return this.scopes.get(0);
    }

    @Override
    public String getLastScope() {
        return this.scopes.get(this.scopes.size() - 1);
    }

    @Override
    public String getMatchingScope(Predicate<String> predicate) {
        for (String item : this.scopes) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withScopes(List<String> scopes) {
        if (this.scopes != null) {
            this._visitables.removeAll(this.scopes);
        }
        if (scopes != null) {
            this.scopes = new ArrayList<String>();
            for (String item : scopes) {
                this.addToScopes(item);
            }
        } else {
            this.scopes = new ArrayList<String>();
        }
        return (A)this;
    }

    @Override
    public A withScopes(String ... scopes) {
        if (this.scopes != null) {
            this.scopes.clear();
        }
        if (scopes != null) {
            for (String item : scopes) {
                this.addToScopes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasScopes() {
        return this.scopes != null && !this.scopes.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceQuotaSpecFluentImpl that = (ResourceQuotaSpecFluentImpl)o;
        if (this.hard != null ? !this.hard.equals(that.hard) : that.hard != null) {
            return false;
        }
        if (this.scopeSelector != null ? !this.scopeSelector.equals(that.scopeSelector) : that.scopeSelector != null) {
            return false;
        }
        return !(this.scopes != null ? !this.scopes.equals(that.scopes) : that.scopes != null);
    }

    public class ScopeSelectorNestedImpl<N>
    extends ScopeSelectorFluentImpl<ResourceQuotaSpecFluent.ScopeSelectorNested<N>>
    implements ResourceQuotaSpecFluent.ScopeSelectorNested<N>,
    Nested<N> {
        private final ScopeSelectorBuilder builder;

        ScopeSelectorNestedImpl(ScopeSelector item) {
            this.builder = new ScopeSelectorBuilder(this, item);
        }

        ScopeSelectorNestedImpl() {
            this.builder = new ScopeSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)ResourceQuotaSpecFluentImpl.this.withScopeSelector(this.builder.build());
        }

        @Override
        public N endScopeSelector() {
            return this.and();
        }
    }
}

