/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_1;

import io.fabric8.kubernetes.api.builder.v4_1.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_1.Nested;
import io.fabric8.kubernetes.api.builder.v4_1.Predicate;
import io.fabric8.kubernetes.api.model.v4_1.PodSecurityContext;
import io.fabric8.kubernetes.api.model.v4_1.PodSecurityContextFluent;
import io.fabric8.kubernetes.api.model.v4_1.SELinuxOptions;
import io.fabric8.kubernetes.api.model.v4_1.SELinuxOptionsBuilder;
import io.fabric8.kubernetes.api.model.v4_1.SELinuxOptionsFluentImpl;
import io.fabric8.kubernetes.api.model.v4_1.Sysctl;
import io.fabric8.kubernetes.api.model.v4_1.SysctlBuilder;
import io.fabric8.kubernetes.api.model.v4_1.SysctlFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PodSecurityContextFluentImpl<A extends PodSecurityContextFluent<A>>
extends BaseFluent<A>
implements PodSecurityContextFluent<A> {
    private Long fsGroup;
    private Long runAsGroup;
    private Boolean runAsNonRoot;
    private Long runAsUser;
    private SELinuxOptionsBuilder seLinuxOptions;
    private List<Long> supplementalGroups;
    private List<SysctlBuilder> sysctls;

    public PodSecurityContextFluentImpl() {
    }

    public PodSecurityContextFluentImpl(PodSecurityContext instance) {
        this.withFsGroup(instance.getFsGroup());
        this.withRunAsGroup(instance.getRunAsGroup());
        this.withRunAsNonRoot(instance.getRunAsNonRoot());
        this.withRunAsUser(instance.getRunAsUser());
        this.withSeLinuxOptions(instance.getSeLinuxOptions());
        this.withSupplementalGroups(instance.getSupplementalGroups());
        this.withSysctls(instance.getSysctls());
    }

    @Override
    public Long getFsGroup() {
        return this.fsGroup;
    }

    @Override
    public A withFsGroup(Long fsGroup) {
        this.fsGroup = fsGroup;
        return (A)this;
    }

    @Override
    public Boolean hasFsGroup() {
        return this.fsGroup != null;
    }

    @Override
    public A withNewFsGroup(String arg1) {
        return this.withFsGroup(new Long(arg1));
    }

    @Override
    public A withNewFsGroup(long arg1) {
        return this.withFsGroup(new Long(arg1));
    }

    @Override
    public Long getRunAsGroup() {
        return this.runAsGroup;
    }

    @Override
    public A withRunAsGroup(Long runAsGroup) {
        this.runAsGroup = runAsGroup;
        return (A)this;
    }

    @Override
    public Boolean hasRunAsGroup() {
        return this.runAsGroup != null;
    }

    @Override
    public A withNewRunAsGroup(String arg1) {
        return this.withRunAsGroup(new Long(arg1));
    }

    @Override
    public A withNewRunAsGroup(long arg1) {
        return this.withRunAsGroup(new Long(arg1));
    }

    @Override
    public Boolean isRunAsNonRoot() {
        return this.runAsNonRoot;
    }

    @Override
    public A withRunAsNonRoot(Boolean runAsNonRoot) {
        this.runAsNonRoot = runAsNonRoot;
        return (A)this;
    }

    @Override
    public Boolean hasRunAsNonRoot() {
        return this.runAsNonRoot != null;
    }

    @Override
    public A withNewRunAsNonRoot(String arg1) {
        return this.withRunAsNonRoot(new Boolean(arg1));
    }

    @Override
    public A withNewRunAsNonRoot(boolean arg1) {
        return this.withRunAsNonRoot(new Boolean(arg1));
    }

    @Override
    public Long getRunAsUser() {
        return this.runAsUser;
    }

    @Override
    public A withRunAsUser(Long runAsUser) {
        this.runAsUser = runAsUser;
        return (A)this;
    }

    @Override
    public Boolean hasRunAsUser() {
        return this.runAsUser != null;
    }

    @Override
    public A withNewRunAsUser(String arg1) {
        return this.withRunAsUser(new Long(arg1));
    }

    @Override
    public A withNewRunAsUser(long arg1) {
        return this.withRunAsUser(new Long(arg1));
    }

    @Override
    @Deprecated
    public SELinuxOptions getSeLinuxOptions() {
        return this.seLinuxOptions != null ? this.seLinuxOptions.build() : null;
    }

    @Override
    public SELinuxOptions buildSeLinuxOptions() {
        return this.seLinuxOptions != null ? this.seLinuxOptions.build() : null;
    }

    @Override
    public A withSeLinuxOptions(SELinuxOptions seLinuxOptions) {
        this._visitables.remove(this.seLinuxOptions);
        if (seLinuxOptions != null) {
            this.seLinuxOptions = new SELinuxOptionsBuilder(seLinuxOptions);
            this._visitables.add(this.seLinuxOptions);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSeLinuxOptions() {
        return this.seLinuxOptions != null;
    }

    @Override
    public A withNewSeLinuxOptions(String level, String role, String type, String user) {
        return this.withSeLinuxOptions(new SELinuxOptions(level, role, type, user));
    }

    @Override
    public PodSecurityContextFluent.SeLinuxOptionsNested<A> withNewSeLinuxOptions() {
        return new SeLinuxOptionsNestedImpl();
    }

    @Override
    public PodSecurityContextFluent.SeLinuxOptionsNested<A> withNewSeLinuxOptionsLike(SELinuxOptions item) {
        return new SeLinuxOptionsNestedImpl(item);
    }

    @Override
    public PodSecurityContextFluent.SeLinuxOptionsNested<A> editSeLinuxOptions() {
        return this.withNewSeLinuxOptionsLike(this.getSeLinuxOptions());
    }

    @Override
    public PodSecurityContextFluent.SeLinuxOptionsNested<A> editOrNewSeLinuxOptions() {
        return this.withNewSeLinuxOptionsLike(this.getSeLinuxOptions() != null ? this.getSeLinuxOptions() : new SELinuxOptionsBuilder().build());
    }

    @Override
    public PodSecurityContextFluent.SeLinuxOptionsNested<A> editOrNewSeLinuxOptionsLike(SELinuxOptions item) {
        return this.withNewSeLinuxOptionsLike(this.getSeLinuxOptions() != null ? this.getSeLinuxOptions() : item);
    }

    @Override
    public A addToSupplementalGroups(int index, Long item) {
        if (this.supplementalGroups == null) {
            this.supplementalGroups = new ArrayList<Long>();
        }
        this.supplementalGroups.add(index, item);
        return (A)this;
    }

    @Override
    public A setToSupplementalGroups(int index, Long item) {
        if (this.supplementalGroups == null) {
            this.supplementalGroups = new ArrayList<Long>();
        }
        this.supplementalGroups.set(index, item);
        return (A)this;
    }

    @Override
    public A addToSupplementalGroups(Long ... items) {
        if (this.supplementalGroups == null) {
            this.supplementalGroups = new ArrayList<Long>();
        }
        for (Long item : items) {
            this.supplementalGroups.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToSupplementalGroups(Collection<Long> items) {
        if (this.supplementalGroups == null) {
            this.supplementalGroups = new ArrayList<Long>();
        }
        for (Long item : items) {
            this.supplementalGroups.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromSupplementalGroups(Long ... items) {
        for (Long item : items) {
            if (this.supplementalGroups == null) continue;
            this.supplementalGroups.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSupplementalGroups(Collection<Long> items) {
        for (Long item : items) {
            if (this.supplementalGroups == null) continue;
            this.supplementalGroups.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Long> getSupplementalGroups() {
        return this.supplementalGroups;
    }

    @Override
    public Long getSupplementalGroup(int index) {
        return this.supplementalGroups.get(index);
    }

    @Override
    public Long getFirstSupplementalGroup() {
        return this.supplementalGroups.get(0);
    }

    @Override
    public Long getLastSupplementalGroup() {
        return this.supplementalGroups.get(this.supplementalGroups.size() - 1);
    }

    @Override
    public Long getMatchingSupplementalGroup(Predicate<Long> predicate) {
        for (Long item : this.supplementalGroups) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withSupplementalGroups(List<Long> supplementalGroups) {
        if (this.supplementalGroups != null) {
            this._visitables.removeAll(this.supplementalGroups);
        }
        if (supplementalGroups != null) {
            this.supplementalGroups = new ArrayList<Long>();
            for (Long item : supplementalGroups) {
                this.addToSupplementalGroups(item);
            }
        } else {
            this.supplementalGroups = new ArrayList<Long>();
        }
        return (A)this;
    }

    @Override
    public A withSupplementalGroups(Long ... supplementalGroups) {
        if (this.supplementalGroups != null) {
            this.supplementalGroups.clear();
        }
        if (supplementalGroups != null) {
            for (Long item : supplementalGroups) {
                this.addToSupplementalGroups(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSupplementalGroups() {
        return this.supplementalGroups != null && !this.supplementalGroups.isEmpty();
    }

    @Override
    public A addNewSupplementalGroup(String arg1) {
        return this.addToSupplementalGroups(new Long(arg1));
    }

    @Override
    public A addNewSupplementalGroup(long arg1) {
        return this.addToSupplementalGroups(new Long(arg1));
    }

    @Override
    public A addToSysctls(int index, Sysctl item) {
        if (this.sysctls == null) {
            this.sysctls = new ArrayList<SysctlBuilder>();
        }
        SysctlBuilder builder = new SysctlBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.sysctls.add(index >= 0 ? index : this.sysctls.size(), builder);
        return (A)this;
    }

    @Override
    public A setToSysctls(int index, Sysctl item) {
        if (this.sysctls == null) {
            this.sysctls = new ArrayList<SysctlBuilder>();
        }
        SysctlBuilder builder = new SysctlBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.sysctls.size()) {
            this.sysctls.add(builder);
        } else {
            this.sysctls.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSysctls(Sysctl ... items) {
        if (this.sysctls == null) {
            this.sysctls = new ArrayList<SysctlBuilder>();
        }
        for (Sysctl item : items) {
            SysctlBuilder builder = new SysctlBuilder(item);
            this._visitables.add(builder);
            this.sysctls.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSysctls(Collection<Sysctl> items) {
        if (this.sysctls == null) {
            this.sysctls = new ArrayList<SysctlBuilder>();
        }
        for (Sysctl item : items) {
            SysctlBuilder builder = new SysctlBuilder(item);
            this._visitables.add(builder);
            this.sysctls.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSysctls(Sysctl ... items) {
        for (Sysctl item : items) {
            SysctlBuilder builder = new SysctlBuilder(item);
            this._visitables.remove(builder);
            if (this.sysctls == null) continue;
            this.sysctls.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSysctls(Collection<Sysctl> items) {
        for (Sysctl item : items) {
            SysctlBuilder builder = new SysctlBuilder(item);
            this._visitables.remove(builder);
            if (this.sysctls == null) continue;
            this.sysctls.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Sysctl> getSysctls() {
        return PodSecurityContextFluentImpl.build(this.sysctls);
    }

    @Override
    public List<Sysctl> buildSysctls() {
        return PodSecurityContextFluentImpl.build(this.sysctls);
    }

    @Override
    public Sysctl buildSysctl(int index) {
        return this.sysctls.get(index).build();
    }

    @Override
    public Sysctl buildFirstSysctl() {
        return this.sysctls.get(0).build();
    }

    @Override
    public Sysctl buildLastSysctl() {
        return this.sysctls.get(this.sysctls.size() - 1).build();
    }

    @Override
    public Sysctl buildMatchingSysctl(Predicate<SysctlBuilder> predicate) {
        for (SysctlBuilder item : this.sysctls) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withSysctls(List<Sysctl> sysctls) {
        if (this.sysctls != null) {
            this._visitables.removeAll(this.sysctls);
        }
        if (sysctls != null) {
            this.sysctls = new ArrayList<SysctlBuilder>();
            for (Sysctl item : sysctls) {
                this.addToSysctls(item);
            }
        } else {
            this.sysctls = new ArrayList<SysctlBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withSysctls(Sysctl ... sysctls) {
        if (this.sysctls != null) {
            this.sysctls.clear();
        }
        if (sysctls != null) {
            for (Sysctl item : sysctls) {
                this.addToSysctls(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSysctls() {
        return this.sysctls != null && !this.sysctls.isEmpty();
    }

    @Override
    public A addNewSysctl(String name, String value) {
        return this.addToSysctls(new Sysctl(name, value));
    }

    @Override
    public PodSecurityContextFluent.SysctlsNested<A> addNewSysctl() {
        return new SysctlsNestedImpl();
    }

    @Override
    public PodSecurityContextFluent.SysctlsNested<A> addNewSysctlLike(Sysctl item) {
        return new SysctlsNestedImpl(-1, item);
    }

    @Override
    public PodSecurityContextFluent.SysctlsNested<A> setNewSysctlLike(int index, Sysctl item) {
        return new SysctlsNestedImpl(index, item);
    }

    @Override
    public PodSecurityContextFluent.SysctlsNested<A> editSysctl(int index) {
        if (this.sysctls.size() <= index) {
            throw new RuntimeException("Can't edit sysctls. Index exceeds size.");
        }
        return this.setNewSysctlLike(index, this.buildSysctl(index));
    }

    @Override
    public PodSecurityContextFluent.SysctlsNested<A> editFirstSysctl() {
        if (this.sysctls.size() == 0) {
            throw new RuntimeException("Can't edit first sysctls. The list is empty.");
        }
        return this.setNewSysctlLike(0, this.buildSysctl(0));
    }

    @Override
    public PodSecurityContextFluent.SysctlsNested<A> editLastSysctl() {
        int index = this.sysctls.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last sysctls. The list is empty.");
        }
        return this.setNewSysctlLike(index, this.buildSysctl(index));
    }

    @Override
    public PodSecurityContextFluent.SysctlsNested<A> editMatchingSysctl(Predicate<SysctlBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.sysctls.size(); ++i) {
            if (!predicate.apply(this.sysctls.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching sysctls. No match found.");
        }
        return this.setNewSysctlLike(index, this.buildSysctl(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodSecurityContextFluentImpl that = (PodSecurityContextFluentImpl)o;
        if (this.fsGroup != null ? !this.fsGroup.equals(that.fsGroup) : that.fsGroup != null) {
            return false;
        }
        if (this.runAsGroup != null ? !this.runAsGroup.equals(that.runAsGroup) : that.runAsGroup != null) {
            return false;
        }
        if (this.runAsNonRoot != null ? !this.runAsNonRoot.equals(that.runAsNonRoot) : that.runAsNonRoot != null) {
            return false;
        }
        if (this.runAsUser != null ? !this.runAsUser.equals(that.runAsUser) : that.runAsUser != null) {
            return false;
        }
        if (this.seLinuxOptions != null ? !this.seLinuxOptions.equals(that.seLinuxOptions) : that.seLinuxOptions != null) {
            return false;
        }
        if (this.supplementalGroups != null ? !this.supplementalGroups.equals(that.supplementalGroups) : that.supplementalGroups != null) {
            return false;
        }
        return !(this.sysctls != null ? !this.sysctls.equals(that.sysctls) : that.sysctls != null);
    }

    public class SysctlsNestedImpl<N>
    extends SysctlFluentImpl<PodSecurityContextFluent.SysctlsNested<N>>
    implements PodSecurityContextFluent.SysctlsNested<N>,
    Nested<N> {
        private final SysctlBuilder builder;
        private final int index;

        SysctlsNestedImpl(int index, Sysctl item) {
            this.index = index;
            this.builder = new SysctlBuilder(this, item);
        }

        SysctlsNestedImpl() {
            this.index = -1;
            this.builder = new SysctlBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodSecurityContextFluentImpl.this.setToSysctls(this.index, this.builder.build());
        }

        @Override
        public N endSysctl() {
            return this.and();
        }
    }

    public class SeLinuxOptionsNestedImpl<N>
    extends SELinuxOptionsFluentImpl<PodSecurityContextFluent.SeLinuxOptionsNested<N>>
    implements PodSecurityContextFluent.SeLinuxOptionsNested<N>,
    Nested<N> {
        private final SELinuxOptionsBuilder builder;

        SeLinuxOptionsNestedImpl(SELinuxOptions item) {
            this.builder = new SELinuxOptionsBuilder(this, item);
        }

        SeLinuxOptionsNestedImpl() {
            this.builder = new SELinuxOptionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodSecurityContextFluentImpl.this.withSeLinuxOptions(this.builder.build());
        }

        @Override
        public N endSeLinuxOptions() {
            return this.and();
        }
    }
}

