/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_1;

import io.fabric8.kubernetes.api.builder.v4_1.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_1.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_1.NamespaceList;
import io.fabric8.kubernetes.api.model.v4_1.NamespaceListFluent;
import io.fabric8.kubernetes.api.model.v4_1.NamespaceListFluentImpl;
import javax.validation.Validator;

public class NamespaceListBuilder
extends NamespaceListFluentImpl<NamespaceListBuilder>
implements VisitableBuilder<NamespaceList, NamespaceListBuilder> {
    NamespaceListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public NamespaceListBuilder() {
        this(true);
    }

    public NamespaceListBuilder(Boolean validationEnabled) {
        this(new NamespaceList(), validationEnabled);
    }

    public NamespaceListBuilder(NamespaceListFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public NamespaceListBuilder(NamespaceListFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NamespaceList(), validationEnabled);
    }

    public NamespaceListBuilder(NamespaceListFluent<?> fluent, NamespaceList instance) {
        this(fluent, instance, true);
    }

    public NamespaceListBuilder(NamespaceListFluent<?> fluent, NamespaceList instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public NamespaceListBuilder(NamespaceList instance) {
        this(instance, (Boolean)true);
    }

    public NamespaceListBuilder(NamespaceList instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public NamespaceListBuilder(Validator validator) {
        this(new NamespaceList(), (Boolean)true);
    }

    public NamespaceListBuilder(NamespaceListFluent<?> fluent, NamespaceList instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public NamespaceListBuilder(NamespaceList instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public NamespaceList build() {
        NamespaceList buildable = new NamespaceList(this.fluent.getApiVersion(), this.fluent.getItems(), this.fluent.getKind(), this.fluent.getMetadata());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamespaceListBuilder that = (NamespaceListBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

