/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_1;

import io.fabric8.kubernetes.api.builder.v4_1.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_1.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_1.EnvVar;
import io.fabric8.kubernetes.api.model.v4_1.EnvVarFluent;
import io.fabric8.kubernetes.api.model.v4_1.EnvVarFluentImpl;
import javax.validation.Validator;

public class EnvVarBuilder
extends EnvVarFluentImpl<EnvVarBuilder>
implements VisitableBuilder<EnvVar, EnvVarBuilder> {
    EnvVarFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public EnvVarBuilder() {
        this(true);
    }

    public EnvVarBuilder(Boolean validationEnabled) {
        this(new EnvVar(), validationEnabled);
    }

    public EnvVarBuilder(EnvVarFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public EnvVarBuilder(EnvVarFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new EnvVar(), validationEnabled);
    }

    public EnvVarBuilder(EnvVarFluent<?> fluent, EnvVar instance) {
        this(fluent, instance, true);
    }

    public EnvVarBuilder(EnvVarFluent<?> fluent, EnvVar instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withValue(instance.getValue());
        fluent.withValueFrom(instance.getValueFrom());
        this.validationEnabled = validationEnabled;
    }

    public EnvVarBuilder(EnvVar instance) {
        this(instance, (Boolean)true);
    }

    public EnvVarBuilder(EnvVar instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withValue(instance.getValue());
        this.withValueFrom(instance.getValueFrom());
        this.validationEnabled = validationEnabled;
    }

    public EnvVarBuilder(Validator validator) {
        this(new EnvVar(), (Boolean)true);
    }

    public EnvVarBuilder(EnvVarFluent<?> fluent, EnvVar instance, Validator validator) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withValue(instance.getValue());
        fluent.withValueFrom(instance.getValueFrom());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public EnvVarBuilder(EnvVar instance, Validator validator) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withValue(instance.getValue());
        this.withValueFrom(instance.getValueFrom());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public EnvVar build() {
        EnvVar buildable = new EnvVar(this.fluent.getName(), this.fluent.getValue(), this.fluent.getValueFrom());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EnvVarBuilder that = (EnvVarBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

