/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_1;

import io.fabric8.kubernetes.api.builder.v4_1.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_1.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_1.Endpoints;
import io.fabric8.kubernetes.api.model.v4_1.EndpointsFluent;
import io.fabric8.kubernetes.api.model.v4_1.EndpointsFluentImpl;
import javax.validation.Validator;

public class EndpointsBuilder
extends EndpointsFluentImpl<EndpointsBuilder>
implements VisitableBuilder<Endpoints, EndpointsBuilder> {
    EndpointsFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public EndpointsBuilder() {
        this(true);
    }

    public EndpointsBuilder(Boolean validationEnabled) {
        this(new Endpoints(), validationEnabled);
    }

    public EndpointsBuilder(EndpointsFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public EndpointsBuilder(EndpointsFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Endpoints(), validationEnabled);
    }

    public EndpointsBuilder(EndpointsFluent<?> fluent, Endpoints instance) {
        this(fluent, instance, true);
    }

    public EndpointsBuilder(EndpointsFluent<?> fluent, Endpoints instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSubsets(instance.getSubsets());
        this.validationEnabled = validationEnabled;
    }

    public EndpointsBuilder(Endpoints instance) {
        this(instance, (Boolean)true);
    }

    public EndpointsBuilder(Endpoints instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSubsets(instance.getSubsets());
        this.validationEnabled = validationEnabled;
    }

    public EndpointsBuilder(Validator validator) {
        this(new Endpoints(), (Boolean)true);
    }

    public EndpointsBuilder(EndpointsFluent<?> fluent, Endpoints instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSubsets(instance.getSubsets());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public EndpointsBuilder(Endpoints instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSubsets(instance.getSubsets());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public Endpoints build() {
        Endpoints buildable = new Endpoints(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSubsets());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EndpointsBuilder that = (EndpointsBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

