/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v4_1;

import io.fabric8.kubernetes.api.builder.v4_1.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_1.VisitableBuilder;
import io.fabric8.openshift.api.model.v4_1.ServiceAccountRestriction;
import io.fabric8.openshift.api.model.v4_1.ServiceAccountRestrictionFluent;
import io.fabric8.openshift.api.model.v4_1.ServiceAccountRestrictionFluentImpl;
import javax.validation.Validator;

public class ServiceAccountRestrictionBuilder
extends ServiceAccountRestrictionFluentImpl<ServiceAccountRestrictionBuilder>
implements VisitableBuilder<ServiceAccountRestriction, ServiceAccountRestrictionBuilder> {
    ServiceAccountRestrictionFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ServiceAccountRestrictionBuilder() {
        this(true);
    }

    public ServiceAccountRestrictionBuilder(Boolean validationEnabled) {
        this(new ServiceAccountRestriction(), validationEnabled);
    }

    public ServiceAccountRestrictionBuilder(ServiceAccountRestrictionFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ServiceAccountRestrictionBuilder(ServiceAccountRestrictionFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ServiceAccountRestriction(), validationEnabled);
    }

    public ServiceAccountRestrictionBuilder(ServiceAccountRestrictionFluent<?> fluent, ServiceAccountRestriction instance) {
        this(fluent, instance, true);
    }

    public ServiceAccountRestrictionBuilder(ServiceAccountRestrictionFluent<?> fluent, ServiceAccountRestriction instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withNamespaces(instance.getNamespaces());
        fluent.withServiceaccounts(instance.getServiceaccounts());
        this.validationEnabled = validationEnabled;
    }

    public ServiceAccountRestrictionBuilder(ServiceAccountRestriction instance) {
        this(instance, (Boolean)true);
    }

    public ServiceAccountRestrictionBuilder(ServiceAccountRestriction instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withNamespaces(instance.getNamespaces());
        this.withServiceaccounts(instance.getServiceaccounts());
        this.validationEnabled = validationEnabled;
    }

    public ServiceAccountRestrictionBuilder(Validator validator) {
        this(new ServiceAccountRestriction(), (Boolean)true);
    }

    public ServiceAccountRestrictionBuilder(ServiceAccountRestrictionFluent<?> fluent, ServiceAccountRestriction instance, Validator validator) {
        this.fluent = fluent;
        fluent.withNamespaces(instance.getNamespaces());
        fluent.withServiceaccounts(instance.getServiceaccounts());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ServiceAccountRestrictionBuilder(ServiceAccountRestriction instance, Validator validator) {
        this.fluent = this;
        this.withNamespaces(instance.getNamespaces());
        this.withServiceaccounts(instance.getServiceaccounts());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public ServiceAccountRestriction build() {
        ServiceAccountRestriction buildable = new ServiceAccountRestriction(this.fluent.getNamespaces(), this.fluent.getServiceaccounts());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceAccountRestrictionBuilder that = (ServiceAccountRestrictionBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

