/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v4_1;

import io.fabric8.kubernetes.api.builder.v4_1.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_1.VisitableBuilder;
import io.fabric8.openshift.api.model.v4_1.DeploymentCause;
import io.fabric8.openshift.api.model.v4_1.DeploymentCauseFluent;
import io.fabric8.openshift.api.model.v4_1.DeploymentCauseFluentImpl;
import javax.validation.Validator;

public class DeploymentCauseBuilder
extends DeploymentCauseFluentImpl<DeploymentCauseBuilder>
implements VisitableBuilder<DeploymentCause, DeploymentCauseBuilder> {
    DeploymentCauseFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public DeploymentCauseBuilder() {
        this(true);
    }

    public DeploymentCauseBuilder(Boolean validationEnabled) {
        this(new DeploymentCause(), validationEnabled);
    }

    public DeploymentCauseBuilder(DeploymentCauseFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public DeploymentCauseBuilder(DeploymentCauseFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new DeploymentCause(), validationEnabled);
    }

    public DeploymentCauseBuilder(DeploymentCauseFluent<?> fluent, DeploymentCause instance) {
        this(fluent, instance, true);
    }

    public DeploymentCauseBuilder(DeploymentCauseFluent<?> fluent, DeploymentCause instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withImageTrigger(instance.getImageTrigger());
        fluent.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    public DeploymentCauseBuilder(DeploymentCause instance) {
        this(instance, (Boolean)true);
    }

    public DeploymentCauseBuilder(DeploymentCause instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withImageTrigger(instance.getImageTrigger());
        this.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    public DeploymentCauseBuilder(Validator validator) {
        this(new DeploymentCause(), (Boolean)true);
    }

    public DeploymentCauseBuilder(DeploymentCauseFluent<?> fluent, DeploymentCause instance, Validator validator) {
        this.fluent = fluent;
        fluent.withImageTrigger(instance.getImageTrigger());
        fluent.withType(instance.getType());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public DeploymentCauseBuilder(DeploymentCause instance, Validator validator) {
        this.fluent = this;
        this.withImageTrigger(instance.getImageTrigger());
        this.withType(instance.getType());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public DeploymentCause build() {
        DeploymentCause buildable = new DeploymentCause(this.fluent.getImageTrigger(), this.fluent.getType());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeploymentCauseBuilder that = (DeploymentCauseBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

