/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_1.utils;

import io.fabric8.kubernetes.clnt.v4_1.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v4_1.utils.IOHelpers;
import io.fabric8.kubernetes.clnt.v4_1.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class ReplaceValueStream {
    private final Map<String, String> valuesMap;

    public static InputStream replaceValues(InputStream is, Map<String, String> valuesMap) {
        return new ReplaceValueStream(valuesMap).createInputStream(is);
    }

    public ReplaceValueStream(Map<String, String> valuesMap) {
        this.valuesMap = valuesMap;
    }

    public InputStream createInputStream(InputStream is) {
        try {
            String json = IOHelpers.readFully(is);
            String replaced = this.replaceValues(json);
            return new ByteArrayInputStream(replaced.getBytes());
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    private String replaceValues(String json) {
        String answer = json;
        for (Map.Entry<String, String> entry : this.valuesMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            answer = Utils.replaceAllWithoutRegex(answer, "${" + key + "}", value);
        }
        return answer;
    }
}

