/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_1;

import io.fabric8.kubernetes.api.model.v4_1.Service;
import io.fabric8.kubernetes.api.model.v4_1.ServicePort;
import io.fabric8.kubernetes.api.model.v4_1.extensions.IngressList;
import io.fabric8.kubernetes.clnt.v4_1.KubernetesClient;
import io.fabric8.kubernetes.clnt.v4_1.ServiceToURLProvider;
import io.fabric8.kubernetes.clnt.v4_1.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v4_1.utils.URLFromServiceUtil;

public class URLFromIngressImpl
implements ServiceToURLProvider {
    @Override
    public String getURL(Service service, String portName, String namespace, KubernetesClient client) {
        ServicePort port = URLFromServiceUtil.getServicePortByName(service, portName);
        String serviceName = service.getMetadata().getName();
        if (port == null) {
            throw new RuntimeException("Couldn't find port: " + portName + " for service " + service.getMetadata().getName());
        }
        IngressList ingresses = (IngressList)((NonNamespaceOperation)client.extensions().ingresses().inNamespace(namespace)).list();
        if (ingresses != null && !ingresses.getItems().isEmpty()) {
            return URLFromServiceUtil.getURLFromIngressList(ingresses.getItems(), namespace, serviceName, port);
        }
        return null;
    }

    @Override
    public int getPriority() {
        return ServiceToURLProvider.ServiceToUrlImplPriority.FIRST.getValue();
    }
}

