/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_1;

import io.fabric8.kubernetes.clnt.v4_1.Client;
import io.fabric8.kubernetes.clnt.v4_1.ExtensionAdapter;
import io.fabric8.kubernetes.clnt.v4_1.HttpClientAware;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Adapters {
    private static final Logger LOGGER = LoggerFactory.getLogger(Adapters.class);
    private static final Set<ClassLoader> CLASS_LOADERS = new HashSet<ClassLoader>();
    private static final Map<Class, ExtensionAdapter> EXTENSION_ADAPTER_MAP = new HashMap<Class, ExtensionAdapter>();
    private static final ExtensionAdapter<OkHttpClient> OK_HTTP_CLIENT_EXTENSION_ADAPTER = new ExtensionAdapter<OkHttpClient>(){

        @Override
        public Class<OkHttpClient> getExtensionType() {
            return OkHttpClient.class;
        }

        @Override
        public Boolean isAdaptable(Client client) {
            return client instanceof HttpClientAware;
        }

        @Override
        public OkHttpClient adapt(Client client) {
            if (client instanceof HttpClientAware) {
                return ((HttpClientAware)((Object)client)).getHttpClient().newBuilder().build();
            }
            throw new IllegalArgumentException("This adapter only supports instances of HttpClientAware.");
        }
    };

    private Adapters() {
    }

    public static <C> void register(ExtensionAdapter<C> adapter) {
        EXTENSION_ADAPTER_MAP.put(adapter.getExtensionType(), adapter);
    }

    public static <C> void unregister(ExtensionAdapter<C> adapter) {
        EXTENSION_ADAPTER_MAP.remove(adapter.getExtensionType());
    }

    public static <C> ExtensionAdapter<C> get(Class<C> type) {
        if (EXTENSION_ADAPTER_MAP.containsKey(type)) {
            return EXTENSION_ADAPTER_MAP.get(type);
        }
        try {
            for (ExtensionAdapter adapter : ServiceLoader.load(ExtensionAdapter.class, ExtensionAdapter.class.getClassLoader())) {
                if (!adapter.getExtensionType().equals(type)) continue;
                return adapter;
            }
        }
        catch (Throwable t) {
            LOGGER.warn("Can't read ExtensionAdapter using the ExtensionAdapter class loader. Falling back to type class loader");
        }
        try {
            for (ExtensionAdapter adapter : ServiceLoader.load(ExtensionAdapter.class, type.getClassLoader())) {
                if (!adapter.getExtensionType().equals(type)) continue;
                return adapter;
            }
        }
        catch (Throwable t) {
            LOGGER.warn("Can't read ExtensionAdapter using type class loader. Falling back to Thread context class loader");
        }
        try {
            for (ExtensionAdapter adapter : ServiceLoader.load(ExtensionAdapter.class, Thread.currentThread().getContextClassLoader())) {
                if (!adapter.getExtensionType().equals(type)) continue;
                return adapter;
            }
        }
        catch (Throwable t) {
            LOGGER.error("Can't read ExtensionAdapter using type Thread context class loader.");
        }
        return null;
    }

    public static <C> Collection<ExtensionAdapter<? extends C>> list(Class<C> type) {
        ArrayList<ExtensionAdapter<C>> result = new ArrayList<ExtensionAdapter<C>>();
        for (ExtensionAdapter candidate : EXTENSION_ADAPTER_MAP.values()) {
            if (!type.isAssignableFrom(candidate.getExtensionType())) continue;
            result.add(candidate);
        }
        return result;
    }

    private static void discoverServices(ClassLoader classLoader) {
        if (classLoader != null && CLASS_LOADERS.add(classLoader)) {
            for (ExtensionAdapter adapter : ServiceLoader.load(ExtensionAdapter.class, classLoader)) {
                Adapters.register(adapter);
            }
        }
    }

    static {
        Adapters.discoverServices(Adapters.class.getClassLoader());
        Adapters.register(OK_HTTP_CLIENT_EXTENSION_ADAPTER);
    }
}

