/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_1.validators;

import io.fabric8.kubernetes.api.model.v4_1.ObjectMeta;
import io.fabric8.kubernetes.api.model.v4_1.validators.CheckObjectMeta;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class ObjectMetaValidator
implements ConstraintValidator<CheckObjectMeta, ObjectMeta> {
    private String regexp;
    private int max;
    private boolean minimal;
    private static final String[] NAME_MAY_NOT_BE = new String[]{".", ".."};
    private static final String[] NAME_MAY_NOT_CONTAIN = new String[]{"/", "%"};

    public void initialize(CheckObjectMeta constraintAnnotation) {
        this.regexp = constraintAnnotation.regexp();
        this.max = constraintAnnotation.max();
        this.minimal = constraintAnnotation.minimal();
    }

    public boolean isValid(ObjectMeta value, ConstraintValidatorContext context) {
        if (value == null || value.getName() == null) {
            return true;
        }
        String name = value.getName();
        if (this.minimal) {
            return this.validateMinimal(name, context);
        }
        return this.validateRegex(name, context);
    }

    private boolean validateRegex(String name, ConstraintValidatorContext context) {
        if (!name.matches(this.regexp)) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate("{io.fabric8.kubernetes.api.model.Pattern.message}").addPropertyNode("name").addConstraintViolation();
            return false;
        }
        if (0 <= this.max && this.max < name.length()) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate("{io.fabric8.kubernetes.api.model.MaxLength.message}").addPropertyNode("name").addConstraintViolation();
            return false;
        }
        return true;
    }

    private boolean validateMinimal(String name, ConstraintValidatorContext context) {
        for (String illegalName : NAME_MAY_NOT_BE) {
            if (!illegalName.equals(name)) continue;
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate("name may not be " + illegalName).addPropertyNode("name").addConstraintViolation();
            return false;
        }
        for (String illegalContent : NAME_MAY_NOT_CONTAIN) {
            if (!name.contains(illegalContent)) continue;
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate("name may not contain " + illegalContent).addPropertyNode("name").addConstraintViolation();
            return false;
        }
        return true;
    }
}

