/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_1.extensions;

import io.fabric8.kubernetes.api.builder.v4_1.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_1.Nested;
import io.fabric8.kubernetes.api.model.v4_1.extensions.HTTPIngressRuleValue;
import io.fabric8.kubernetes.api.model.v4_1.extensions.HTTPIngressRuleValueBuilder;
import io.fabric8.kubernetes.api.model.v4_1.extensions.HTTPIngressRuleValueFluentImpl;
import io.fabric8.kubernetes.api.model.v4_1.extensions.IngressRule;
import io.fabric8.kubernetes.api.model.v4_1.extensions.IngressRuleFluent;

public class IngressRuleFluentImpl<A extends IngressRuleFluent<A>>
extends BaseFluent<A>
implements IngressRuleFluent<A> {
    private String host;
    private HTTPIngressRuleValueBuilder http;

    public IngressRuleFluentImpl() {
    }

    public IngressRuleFluentImpl(IngressRule instance) {
        this.withHost(instance.getHost());
        this.withHttp(instance.getHttp());
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public A withHost(String host) {
        this.host = host;
        return (A)this;
    }

    @Override
    public Boolean hasHost() {
        return this.host != null;
    }

    @Override
    @Deprecated
    public HTTPIngressRuleValue getHttp() {
        return this.http != null ? this.http.build() : null;
    }

    @Override
    public HTTPIngressRuleValue buildHttp() {
        return this.http != null ? this.http.build() : null;
    }

    @Override
    public A withHttp(HTTPIngressRuleValue http) {
        this._visitables.remove(this.http);
        if (http != null) {
            this.http = new HTTPIngressRuleValueBuilder(http);
            this._visitables.add(this.http);
        }
        return (A)this;
    }

    @Override
    public Boolean hasHttp() {
        return this.http != null;
    }

    @Override
    public IngressRuleFluent.HttpNested<A> withNewHttp() {
        return new HttpNestedImpl();
    }

    @Override
    public IngressRuleFluent.HttpNested<A> withNewHttpLike(HTTPIngressRuleValue item) {
        return new HttpNestedImpl(item);
    }

    @Override
    public IngressRuleFluent.HttpNested<A> editHttp() {
        return this.withNewHttpLike(this.getHttp());
    }

    @Override
    public IngressRuleFluent.HttpNested<A> editOrNewHttp() {
        return this.withNewHttpLike(this.getHttp() != null ? this.getHttp() : new HTTPIngressRuleValueBuilder().build());
    }

    @Override
    public IngressRuleFluent.HttpNested<A> editOrNewHttpLike(HTTPIngressRuleValue item) {
        return this.withNewHttpLike(this.getHttp() != null ? this.getHttp() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressRuleFluentImpl that = (IngressRuleFluentImpl)o;
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        return !(this.http != null ? !this.http.equals(that.http) : that.http != null);
    }

    public class HttpNestedImpl<N>
    extends HTTPIngressRuleValueFluentImpl<IngressRuleFluent.HttpNested<N>>
    implements IngressRuleFluent.HttpNested<N>,
    Nested<N> {
        private final HTTPIngressRuleValueBuilder builder;

        HttpNestedImpl(HTTPIngressRuleValue item) {
            this.builder = new HTTPIngressRuleValueBuilder(this, item);
        }

        HttpNestedImpl() {
            this.builder = new HTTPIngressRuleValueBuilder(this);
        }

        @Override
        public N and() {
            return (N)IngressRuleFluentImpl.this.withHttp(this.builder.build());
        }

        @Override
        public N endHttp() {
            return this.and();
        }
    }
}

