/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_1.extensions;

import io.fabric8.kubernetes.api.builder.v4_1.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_1.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_1.extensions.IDRange;
import io.fabric8.kubernetes.api.model.v4_1.extensions.IDRangeFluent;
import io.fabric8.kubernetes.api.model.v4_1.extensions.IDRangeFluentImpl;
import javax.validation.Validator;

public class IDRangeBuilder
extends IDRangeFluentImpl<IDRangeBuilder>
implements VisitableBuilder<IDRange, IDRangeBuilder> {
    IDRangeFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public IDRangeBuilder() {
        this(true);
    }

    public IDRangeBuilder(Boolean validationEnabled) {
        this(new IDRange(), validationEnabled);
    }

    public IDRangeBuilder(IDRangeFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public IDRangeBuilder(IDRangeFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new IDRange(), validationEnabled);
    }

    public IDRangeBuilder(IDRangeFluent<?> fluent, IDRange instance) {
        this(fluent, instance, true);
    }

    public IDRangeBuilder(IDRangeFluent<?> fluent, IDRange instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withMax(instance.getMax());
        fluent.withMin(instance.getMin());
        this.validationEnabled = validationEnabled;
    }

    public IDRangeBuilder(IDRange instance) {
        this(instance, (Boolean)true);
    }

    public IDRangeBuilder(IDRange instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withMax(instance.getMax());
        this.withMin(instance.getMin());
        this.validationEnabled = validationEnabled;
    }

    public IDRangeBuilder(Validator validator) {
        this(new IDRange(), (Boolean)true);
    }

    public IDRangeBuilder(IDRangeFluent<?> fluent, IDRange instance, Validator validator) {
        this.fluent = fluent;
        fluent.withMax(instance.getMax());
        fluent.withMin(instance.getMin());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public IDRangeBuilder(IDRange instance, Validator validator) {
        this.fluent = this;
        this.withMax(instance.getMax());
        this.withMin(instance.getMin());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public IDRange build() {
        IDRange buildable = new IDRange(this.fluent.getMax(), this.fluent.getMin());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IDRangeBuilder that = (IDRangeBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

