/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_1.apps;

import io.fabric8.kubernetes.api.builder.v4_1.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_1.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_1.apps.DeploymentList;
import io.fabric8.kubernetes.api.model.v4_1.apps.DeploymentListFluent;
import io.fabric8.kubernetes.api.model.v4_1.apps.DeploymentListFluentImpl;
import javax.validation.Validator;

public class DeploymentListBuilder
extends DeploymentListFluentImpl<DeploymentListBuilder>
implements VisitableBuilder<DeploymentList, DeploymentListBuilder> {
    DeploymentListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public DeploymentListBuilder() {
        this(true);
    }

    public DeploymentListBuilder(Boolean validationEnabled) {
        this(new DeploymentList(), validationEnabled);
    }

    public DeploymentListBuilder(DeploymentListFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public DeploymentListBuilder(DeploymentListFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new DeploymentList(), validationEnabled);
    }

    public DeploymentListBuilder(DeploymentListFluent<?> fluent, DeploymentList instance) {
        this(fluent, instance, true);
    }

    public DeploymentListBuilder(DeploymentListFluent<?> fluent, DeploymentList instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public DeploymentListBuilder(DeploymentList instance) {
        this(instance, (Boolean)true);
    }

    public DeploymentListBuilder(DeploymentList instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public DeploymentListBuilder(Validator validator) {
        this(new DeploymentList(), (Boolean)true);
    }

    public DeploymentListBuilder(DeploymentListFluent<?> fluent, DeploymentList instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public DeploymentListBuilder(DeploymentList instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public DeploymentList build() {
        DeploymentList buildable = new DeploymentList(this.fluent.getApiVersion(), this.fluent.getItems(), this.fluent.getKind(), this.fluent.getMetadata());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeploymentListBuilder that = (DeploymentListBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

