/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_1;

import io.fabric8.kubernetes.api.builder.v4_1.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_1.Nested;
import io.fabric8.kubernetes.api.model.v4_1.Quantity;
import io.fabric8.kubernetes.api.model.v4_1.QuantityBuilder;
import io.fabric8.kubernetes.api.model.v4_1.QuantityFluentImpl;
import io.fabric8.kubernetes.api.model.v4_1.ResourceMetricSource;
import io.fabric8.kubernetes.api.model.v4_1.ResourceMetricSourceFluent;

public class ResourceMetricSourceFluentImpl<A extends ResourceMetricSourceFluent<A>>
extends BaseFluent<A>
implements ResourceMetricSourceFluent<A> {
    private String name;
    private Integer targetAverageUtilization;
    private QuantityBuilder targetAverageValue;

    public ResourceMetricSourceFluentImpl() {
    }

    public ResourceMetricSourceFluentImpl(ResourceMetricSource instance) {
        this.withName(instance.getName());
        this.withTargetAverageUtilization(instance.getTargetAverageUtilization());
        this.withTargetAverageValue(instance.getTargetAverageValue());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public Integer getTargetAverageUtilization() {
        return this.targetAverageUtilization;
    }

    @Override
    public A withTargetAverageUtilization(Integer targetAverageUtilization) {
        this.targetAverageUtilization = targetAverageUtilization;
        return (A)this;
    }

    @Override
    public Boolean hasTargetAverageUtilization() {
        return this.targetAverageUtilization != null;
    }

    @Override
    @Deprecated
    public Quantity getTargetAverageValue() {
        return this.targetAverageValue != null ? this.targetAverageValue.build() : null;
    }

    @Override
    public Quantity buildTargetAverageValue() {
        return this.targetAverageValue != null ? this.targetAverageValue.build() : null;
    }

    @Override
    public A withTargetAverageValue(Quantity targetAverageValue) {
        this._visitables.remove(this.targetAverageValue);
        if (targetAverageValue != null) {
            this.targetAverageValue = new QuantityBuilder(targetAverageValue);
            this._visitables.add(this.targetAverageValue);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTargetAverageValue() {
        return this.targetAverageValue != null;
    }

    @Override
    public A withNewTargetAverageValue(String amount, String format) {
        return this.withTargetAverageValue(new Quantity(amount, format));
    }

    @Override
    public A withNewTargetAverageValue(String amount) {
        return this.withTargetAverageValue(new Quantity(amount));
    }

    @Override
    public ResourceMetricSourceFluent.TargetAverageValueNested<A> withNewTargetAverageValue() {
        return new TargetAverageValueNestedImpl();
    }

    @Override
    public ResourceMetricSourceFluent.TargetAverageValueNested<A> withNewTargetAverageValueLike(Quantity item) {
        return new TargetAverageValueNestedImpl(item);
    }

    @Override
    public ResourceMetricSourceFluent.TargetAverageValueNested<A> editTargetAverageValue() {
        return this.withNewTargetAverageValueLike(this.getTargetAverageValue());
    }

    @Override
    public ResourceMetricSourceFluent.TargetAverageValueNested<A> editOrNewTargetAverageValue() {
        return this.withNewTargetAverageValueLike(this.getTargetAverageValue() != null ? this.getTargetAverageValue() : new QuantityBuilder().build());
    }

    @Override
    public ResourceMetricSourceFluent.TargetAverageValueNested<A> editOrNewTargetAverageValueLike(Quantity item) {
        return this.withNewTargetAverageValueLike(this.getTargetAverageValue() != null ? this.getTargetAverageValue() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceMetricSourceFluentImpl that = (ResourceMetricSourceFluentImpl)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.targetAverageUtilization != null ? !this.targetAverageUtilization.equals(that.targetAverageUtilization) : that.targetAverageUtilization != null) {
            return false;
        }
        return !(this.targetAverageValue != null ? !this.targetAverageValue.equals(that.targetAverageValue) : that.targetAverageValue != null);
    }

    public class TargetAverageValueNestedImpl<N>
    extends QuantityFluentImpl<ResourceMetricSourceFluent.TargetAverageValueNested<N>>
    implements ResourceMetricSourceFluent.TargetAverageValueNested<N>,
    Nested<N> {
        private final QuantityBuilder builder;

        TargetAverageValueNestedImpl(Quantity item) {
            this.builder = new QuantityBuilder(this, item);
        }

        TargetAverageValueNestedImpl() {
            this.builder = new QuantityBuilder(this);
        }

        @Override
        public N and() {
            return (N)ResourceMetricSourceFluentImpl.this.withTargetAverageValue(this.builder.build());
        }

        @Override
        public N endTargetAverageValue() {
            return this.and();
        }
    }
}

