/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_1;

import io.fabric8.kubernetes.api.builder.v4_1.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_1.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_1.ReplicationController;
import io.fabric8.kubernetes.api.model.v4_1.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.v4_1.ReplicationControllerFluentImpl;
import javax.validation.Validator;

public class ReplicationControllerBuilder
extends ReplicationControllerFluentImpl<ReplicationControllerBuilder>
implements VisitableBuilder<ReplicationController, ReplicationControllerBuilder> {
    ReplicationControllerFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ReplicationControllerBuilder() {
        this(true);
    }

    public ReplicationControllerBuilder(Boolean validationEnabled) {
        this(new ReplicationController(), validationEnabled);
    }

    public ReplicationControllerBuilder(ReplicationControllerFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ReplicationControllerBuilder(ReplicationControllerFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ReplicationController(), validationEnabled);
    }

    public ReplicationControllerBuilder(ReplicationControllerFluent<?> fluent, ReplicationController instance) {
        this(fluent, instance, true);
    }

    public ReplicationControllerBuilder(ReplicationControllerFluent<?> fluent, ReplicationController instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public ReplicationControllerBuilder(ReplicationController instance) {
        this(instance, (Boolean)true);
    }

    public ReplicationControllerBuilder(ReplicationController instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public ReplicationControllerBuilder(Validator validator) {
        this(new ReplicationController(), (Boolean)true);
    }

    public ReplicationControllerBuilder(ReplicationControllerFluent<?> fluent, ReplicationController instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ReplicationControllerBuilder(ReplicationController instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public ReplicationController build() {
        ReplicationController buildable = new ReplicationController(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ReplicationControllerBuilder that = (ReplicationControllerBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

