/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_1;

import io.fabric8.kubernetes.api.builder.v4_1.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_1.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_1.Quantity;
import io.fabric8.kubernetes.api.model.v4_1.QuantityFluent;
import io.fabric8.kubernetes.api.model.v4_1.QuantityFluentImpl;
import javax.validation.Validator;

public class QuantityBuilder
extends QuantityFluentImpl<QuantityBuilder>
implements VisitableBuilder<Quantity, QuantityBuilder> {
    QuantityFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public QuantityBuilder() {
        this(true);
    }

    public QuantityBuilder(Boolean validationEnabled) {
        this(new Quantity(), validationEnabled);
    }

    public QuantityBuilder(QuantityFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public QuantityBuilder(QuantityFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Quantity(), validationEnabled);
    }

    public QuantityBuilder(QuantityFluent<?> fluent, Quantity instance) {
        this(fluent, instance, true);
    }

    public QuantityBuilder(QuantityFluent<?> fluent, Quantity instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAmount(instance.getAmount());
        fluent.withFormat(instance.getFormat());
        this.validationEnabled = validationEnabled;
    }

    public QuantityBuilder(Quantity instance) {
        this(instance, (Boolean)true);
    }

    public QuantityBuilder(Quantity instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAmount(instance.getAmount());
        this.withFormat(instance.getFormat());
        this.validationEnabled = validationEnabled;
    }

    public QuantityBuilder(Validator validator) {
        this(new Quantity(), (Boolean)true);
    }

    public QuantityBuilder(QuantityFluent<?> fluent, Quantity instance, Validator validator) {
        this.fluent = fluent;
        fluent.withAmount(instance.getAmount());
        fluent.withFormat(instance.getFormat());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public QuantityBuilder(Quantity instance, Validator validator) {
        this.fluent = this;
        this.withAmount(instance.getAmount());
        this.withFormat(instance.getFormat());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public Quantity build() {
        Quantity buildable = new Quantity(this.fluent.getAmount());
        buildable.setFormat(this.fluent.getFormat());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        QuantityBuilder that = (QuantityBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

