/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_1;

import io.fabric8.kubernetes.api.builder.v4_1.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_1.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_1.PodsMetricSource;
import io.fabric8.kubernetes.api.model.v4_1.PodsMetricSourceFluent;
import io.fabric8.kubernetes.api.model.v4_1.PodsMetricSourceFluentImpl;
import javax.validation.Validator;

public class PodsMetricSourceBuilder
extends PodsMetricSourceFluentImpl<PodsMetricSourceBuilder>
implements VisitableBuilder<PodsMetricSource, PodsMetricSourceBuilder> {
    PodsMetricSourceFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public PodsMetricSourceBuilder() {
        this(true);
    }

    public PodsMetricSourceBuilder(Boolean validationEnabled) {
        this(new PodsMetricSource(), validationEnabled);
    }

    public PodsMetricSourceBuilder(PodsMetricSourceFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public PodsMetricSourceBuilder(PodsMetricSourceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new PodsMetricSource(), validationEnabled);
    }

    public PodsMetricSourceBuilder(PodsMetricSourceFluent<?> fluent, PodsMetricSource instance) {
        this(fluent, instance, true);
    }

    public PodsMetricSourceBuilder(PodsMetricSourceFluent<?> fluent, PodsMetricSource instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withMetricName(instance.getMetricName());
        fluent.withSelector(instance.getSelector());
        fluent.withTargetAverageValue(instance.getTargetAverageValue());
        this.validationEnabled = validationEnabled;
    }

    public PodsMetricSourceBuilder(PodsMetricSource instance) {
        this(instance, (Boolean)true);
    }

    public PodsMetricSourceBuilder(PodsMetricSource instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withMetricName(instance.getMetricName());
        this.withSelector(instance.getSelector());
        this.withTargetAverageValue(instance.getTargetAverageValue());
        this.validationEnabled = validationEnabled;
    }

    public PodsMetricSourceBuilder(Validator validator) {
        this(new PodsMetricSource(), (Boolean)true);
    }

    public PodsMetricSourceBuilder(PodsMetricSourceFluent<?> fluent, PodsMetricSource instance, Validator validator) {
        this.fluent = fluent;
        fluent.withMetricName(instance.getMetricName());
        fluent.withSelector(instance.getSelector());
        fluent.withTargetAverageValue(instance.getTargetAverageValue());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public PodsMetricSourceBuilder(PodsMetricSource instance, Validator validator) {
        this.fluent = this;
        this.withMetricName(instance.getMetricName());
        this.withSelector(instance.getSelector());
        this.withTargetAverageValue(instance.getTargetAverageValue());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public PodsMetricSource build() {
        PodsMetricSource buildable = new PodsMetricSource(this.fluent.getMetricName(), this.fluent.getSelector(), this.fluent.getTargetAverageValue());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodsMetricSourceBuilder that = (PodsMetricSourceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

