/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_1;

import io.fabric8.kubernetes.api.builder.v4_1.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_1.Nested;
import io.fabric8.kubernetes.api.builder.v4_1.Predicate;
import io.fabric8.kubernetes.api.model.v4_1.NodeSelector;
import io.fabric8.kubernetes.api.model.v4_1.NodeSelectorFluent;
import io.fabric8.kubernetes.api.model.v4_1.NodeSelectorTerm;
import io.fabric8.kubernetes.api.model.v4_1.NodeSelectorTermBuilder;
import io.fabric8.kubernetes.api.model.v4_1.NodeSelectorTermFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NodeSelectorFluentImpl<A extends NodeSelectorFluent<A>>
extends BaseFluent<A>
implements NodeSelectorFluent<A> {
    private List<NodeSelectorTermBuilder> nodeSelectorTerms;

    public NodeSelectorFluentImpl() {
    }

    public NodeSelectorFluentImpl(NodeSelector instance) {
        this.withNodeSelectorTerms(instance.getNodeSelectorTerms());
    }

    @Override
    public A addToNodeSelectorTerms(int index, NodeSelectorTerm item) {
        if (this.nodeSelectorTerms == null) {
            this.nodeSelectorTerms = new ArrayList<NodeSelectorTermBuilder>();
        }
        NodeSelectorTermBuilder builder = new NodeSelectorTermBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.nodeSelectorTerms.add(index >= 0 ? index : this.nodeSelectorTerms.size(), builder);
        return (A)this;
    }

    @Override
    public A setToNodeSelectorTerms(int index, NodeSelectorTerm item) {
        if (this.nodeSelectorTerms == null) {
            this.nodeSelectorTerms = new ArrayList<NodeSelectorTermBuilder>();
        }
        NodeSelectorTermBuilder builder = new NodeSelectorTermBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.nodeSelectorTerms.size()) {
            this.nodeSelectorTerms.add(builder);
        } else {
            this.nodeSelectorTerms.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToNodeSelectorTerms(NodeSelectorTerm ... items) {
        if (this.nodeSelectorTerms == null) {
            this.nodeSelectorTerms = new ArrayList<NodeSelectorTermBuilder>();
        }
        for (NodeSelectorTerm item : items) {
            NodeSelectorTermBuilder builder = new NodeSelectorTermBuilder(item);
            this._visitables.add(builder);
            this.nodeSelectorTerms.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToNodeSelectorTerms(Collection<NodeSelectorTerm> items) {
        if (this.nodeSelectorTerms == null) {
            this.nodeSelectorTerms = new ArrayList<NodeSelectorTermBuilder>();
        }
        for (NodeSelectorTerm item : items) {
            NodeSelectorTermBuilder builder = new NodeSelectorTermBuilder(item);
            this._visitables.add(builder);
            this.nodeSelectorTerms.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromNodeSelectorTerms(NodeSelectorTerm ... items) {
        for (NodeSelectorTerm item : items) {
            NodeSelectorTermBuilder builder = new NodeSelectorTermBuilder(item);
            this._visitables.remove(builder);
            if (this.nodeSelectorTerms == null) continue;
            this.nodeSelectorTerms.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromNodeSelectorTerms(Collection<NodeSelectorTerm> items) {
        for (NodeSelectorTerm item : items) {
            NodeSelectorTermBuilder builder = new NodeSelectorTermBuilder(item);
            this._visitables.remove(builder);
            if (this.nodeSelectorTerms == null) continue;
            this.nodeSelectorTerms.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<NodeSelectorTerm> getNodeSelectorTerms() {
        return NodeSelectorFluentImpl.build(this.nodeSelectorTerms);
    }

    @Override
    public List<NodeSelectorTerm> buildNodeSelectorTerms() {
        return NodeSelectorFluentImpl.build(this.nodeSelectorTerms);
    }

    @Override
    public NodeSelectorTerm buildNodeSelectorTerm(int index) {
        return this.nodeSelectorTerms.get(index).build();
    }

    @Override
    public NodeSelectorTerm buildFirstNodeSelectorTerm() {
        return this.nodeSelectorTerms.get(0).build();
    }

    @Override
    public NodeSelectorTerm buildLastNodeSelectorTerm() {
        return this.nodeSelectorTerms.get(this.nodeSelectorTerms.size() - 1).build();
    }

    @Override
    public NodeSelectorTerm buildMatchingNodeSelectorTerm(Predicate<NodeSelectorTermBuilder> predicate) {
        for (NodeSelectorTermBuilder item : this.nodeSelectorTerms) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withNodeSelectorTerms(List<NodeSelectorTerm> nodeSelectorTerms) {
        if (this.nodeSelectorTerms != null) {
            this._visitables.removeAll(this.nodeSelectorTerms);
        }
        if (nodeSelectorTerms != null) {
            this.nodeSelectorTerms = new ArrayList<NodeSelectorTermBuilder>();
            for (NodeSelectorTerm item : nodeSelectorTerms) {
                this.addToNodeSelectorTerms(item);
            }
        } else {
            this.nodeSelectorTerms = new ArrayList<NodeSelectorTermBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withNodeSelectorTerms(NodeSelectorTerm ... nodeSelectorTerms) {
        if (this.nodeSelectorTerms != null) {
            this.nodeSelectorTerms.clear();
        }
        if (nodeSelectorTerms != null) {
            for (NodeSelectorTerm item : nodeSelectorTerms) {
                this.addToNodeSelectorTerms(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasNodeSelectorTerms() {
        return this.nodeSelectorTerms != null && !this.nodeSelectorTerms.isEmpty();
    }

    @Override
    public NodeSelectorFluent.NodeSelectorTermsNested<A> addNewNodeSelectorTerm() {
        return new NodeSelectorTermsNestedImpl();
    }

    @Override
    public NodeSelectorFluent.NodeSelectorTermsNested<A> addNewNodeSelectorTermLike(NodeSelectorTerm item) {
        return new NodeSelectorTermsNestedImpl(-1, item);
    }

    @Override
    public NodeSelectorFluent.NodeSelectorTermsNested<A> setNewNodeSelectorTermLike(int index, NodeSelectorTerm item) {
        return new NodeSelectorTermsNestedImpl(index, item);
    }

    @Override
    public NodeSelectorFluent.NodeSelectorTermsNested<A> editNodeSelectorTerm(int index) {
        if (this.nodeSelectorTerms.size() <= index) {
            throw new RuntimeException("Can't edit nodeSelectorTerms. Index exceeds size.");
        }
        return this.setNewNodeSelectorTermLike(index, this.buildNodeSelectorTerm(index));
    }

    @Override
    public NodeSelectorFluent.NodeSelectorTermsNested<A> editFirstNodeSelectorTerm() {
        if (this.nodeSelectorTerms.size() == 0) {
            throw new RuntimeException("Can't edit first nodeSelectorTerms. The list is empty.");
        }
        return this.setNewNodeSelectorTermLike(0, this.buildNodeSelectorTerm(0));
    }

    @Override
    public NodeSelectorFluent.NodeSelectorTermsNested<A> editLastNodeSelectorTerm() {
        int index = this.nodeSelectorTerms.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last nodeSelectorTerms. The list is empty.");
        }
        return this.setNewNodeSelectorTermLike(index, this.buildNodeSelectorTerm(index));
    }

    @Override
    public NodeSelectorFluent.NodeSelectorTermsNested<A> editMatchingNodeSelectorTerm(Predicate<NodeSelectorTermBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.nodeSelectorTerms.size(); ++i) {
            if (!predicate.apply(this.nodeSelectorTerms.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching nodeSelectorTerms. No match found.");
        }
        return this.setNewNodeSelectorTermLike(index, this.buildNodeSelectorTerm(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeSelectorFluentImpl that = (NodeSelectorFluentImpl)o;
        return !(this.nodeSelectorTerms != null ? !this.nodeSelectorTerms.equals(that.nodeSelectorTerms) : that.nodeSelectorTerms != null);
    }

    public class NodeSelectorTermsNestedImpl<N>
    extends NodeSelectorTermFluentImpl<NodeSelectorFluent.NodeSelectorTermsNested<N>>
    implements NodeSelectorFluent.NodeSelectorTermsNested<N>,
    Nested<N> {
        private final NodeSelectorTermBuilder builder;
        private final int index;

        NodeSelectorTermsNestedImpl(int index, NodeSelectorTerm item) {
            this.index = index;
            this.builder = new NodeSelectorTermBuilder(this, item);
        }

        NodeSelectorTermsNestedImpl() {
            this.index = -1;
            this.builder = new NodeSelectorTermBuilder(this);
        }

        @Override
        public N and() {
            return (N)NodeSelectorFluentImpl.this.setToNodeSelectorTerms(this.index, this.builder.build());
        }

        @Override
        public N endNodeSelectorTerm() {
            return this.and();
        }
    }
}

