/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_1;

import io.fabric8.kubernetes.api.builder.v4_1.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_1.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_1.LocalObjectReference;
import io.fabric8.kubernetes.api.model.v4_1.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.v4_1.LocalObjectReferenceFluentImpl;
import javax.validation.Validator;

public class LocalObjectReferenceBuilder
extends LocalObjectReferenceFluentImpl<LocalObjectReferenceBuilder>
implements VisitableBuilder<LocalObjectReference, LocalObjectReferenceBuilder> {
    LocalObjectReferenceFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public LocalObjectReferenceBuilder() {
        this(true);
    }

    public LocalObjectReferenceBuilder(Boolean validationEnabled) {
        this(new LocalObjectReference(), validationEnabled);
    }

    public LocalObjectReferenceBuilder(LocalObjectReferenceFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public LocalObjectReferenceBuilder(LocalObjectReferenceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new LocalObjectReference(), validationEnabled);
    }

    public LocalObjectReferenceBuilder(LocalObjectReferenceFluent<?> fluent, LocalObjectReference instance) {
        this(fluent, instance, true);
    }

    public LocalObjectReferenceBuilder(LocalObjectReferenceFluent<?> fluent, LocalObjectReference instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    public LocalObjectReferenceBuilder(LocalObjectReference instance) {
        this(instance, (Boolean)true);
    }

    public LocalObjectReferenceBuilder(LocalObjectReference instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    public LocalObjectReferenceBuilder(Validator validator) {
        this(new LocalObjectReference(), (Boolean)true);
    }

    public LocalObjectReferenceBuilder(LocalObjectReferenceFluent<?> fluent, LocalObjectReference instance, Validator validator) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public LocalObjectReferenceBuilder(LocalObjectReference instance, Validator validator) {
        this.fluent = this;
        this.withName(instance.getName());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public LocalObjectReference build() {
        LocalObjectReference buildable = new LocalObjectReference(this.fluent.getName());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LocalObjectReferenceBuilder that = (LocalObjectReferenceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

