/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_1;

import io.fabric8.kubernetes.api.builder.v4_1.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_1.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_1.Context;
import io.fabric8.kubernetes.api.model.v4_1.ContextFluent;
import io.fabric8.kubernetes.api.model.v4_1.ContextFluentImpl;
import javax.validation.Validator;

public class ContextBuilder
extends ContextFluentImpl<ContextBuilder>
implements VisitableBuilder<Context, ContextBuilder> {
    ContextFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ContextBuilder() {
        this(true);
    }

    public ContextBuilder(Boolean validationEnabled) {
        this(new Context(), validationEnabled);
    }

    public ContextBuilder(ContextFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ContextBuilder(ContextFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Context(), validationEnabled);
    }

    public ContextBuilder(ContextFluent<?> fluent, Context instance) {
        this(fluent, instance, true);
    }

    public ContextBuilder(ContextFluent<?> fluent, Context instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCluster(instance.getCluster());
        fluent.withExtensions(instance.getExtensions());
        fluent.withNamespace(instance.getNamespace());
        fluent.withUser(instance.getUser());
        this.validationEnabled = validationEnabled;
    }

    public ContextBuilder(Context instance) {
        this(instance, (Boolean)true);
    }

    public ContextBuilder(Context instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCluster(instance.getCluster());
        this.withExtensions(instance.getExtensions());
        this.withNamespace(instance.getNamespace());
        this.withUser(instance.getUser());
        this.validationEnabled = validationEnabled;
    }

    public ContextBuilder(Validator validator) {
        this(new Context(), (Boolean)true);
    }

    public ContextBuilder(ContextFluent<?> fluent, Context instance, Validator validator) {
        this.fluent = fluent;
        fluent.withCluster(instance.getCluster());
        fluent.withExtensions(instance.getExtensions());
        fluent.withNamespace(instance.getNamespace());
        fluent.withUser(instance.getUser());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ContextBuilder(Context instance, Validator validator) {
        this.fluent = this;
        this.withCluster(instance.getCluster());
        this.withExtensions(instance.getExtensions());
        this.withNamespace(instance.getNamespace());
        this.withUser(instance.getUser());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public Context build() {
        Context buildable = new Context(this.fluent.getCluster(), this.fluent.getExtensions(), this.fluent.getNamespace(), this.fluent.getUser());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContextBuilder that = (ContextBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

