/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v4_1.dsl.internal;

import io.fabric8.kubernetes.api.model.v4_1.Doneable;
import io.fabric8.kubernetes.api.model.v4_1.HasMetadata;
import io.fabric8.kubernetes.api.model.v4_1.KubernetesResourceList;
import io.fabric8.kubernetes.clnt.v4_1.Config;
import io.fabric8.kubernetes.clnt.v4_1.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v4_1.dsl.Resource;
import io.fabric8.kubernetes.clnt.v4_1.dsl.base.ConfigAndApiGroupsInfo;
import io.fabric8.kubernetes.clnt.v4_1.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.clnt.v4_1.utils.URLUtils;
import io.fabric8.openshift.clnt.v4_1.DefaultOpenShiftClient;
import io.fabric8.openshift.clnt.v4_1.OpenShiftClient;
import io.fabric8.openshift.clnt.v4_1.OpenShiftConfig;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import okhttp3.OkHttpClient;

public class OpenShiftOperation<T extends HasMetadata, L extends KubernetesResourceList, D extends Doneable<T>, R extends Resource<T, D>>
extends HasMetadataOperation<T, L, D, R> {
    protected OpenShiftOperation(OkHttpClient client, ConfigAndApiGroupsInfo config, String resourceT, String namespace, String name, Boolean cascading, T item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields) {
        super(client, config.getConfig(), config.getApiGroup(), config.getApiGroupVersion(), resourceT, namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields);
        this.apiGroupVersion = config.getApiGroupVersion();
    }

    public static ConfigAndApiGroupsInfo withApiGroup(OpenShiftClient openShiftClient, String apiGroupName, String apiVersion, OpenShiftConfig config) {
        String oapiVersion = config.getOapiVersion();
        if (config.isOpenShiftAPIGroups(openShiftClient)) {
            String apiGroupUrl = URLUtils.join(config.getMasterUrl(), "apis", apiGroupName, oapiVersion);
            String apiGroupVersion = URLUtils.join(apiGroupName, oapiVersion);
            return new ConfigAndApiGroupsInfo(new OpenShiftConfig(config, apiGroupUrl), apiGroupName, apiGroupVersion);
        }
        if (apiVersion == null) {
            apiVersion = oapiVersion;
        }
        return new ConfigAndApiGroupsInfo(config, apiGroupName, apiVersion);
    }

    public static ConfigAndApiGroupsInfo withApiGroup(OkHttpClient httpClient, String apiGroupName, String apiVersion, OpenShiftConfig config) {
        DefaultOpenShiftClient openShiftClient = new DefaultOpenShiftClient(httpClient, config);
        return OpenShiftOperation.withApiGroup(openShiftClient, apiGroupName, apiVersion, config);
    }

    @Override
    public URL getRootUrl() {
        try {
            return new URL(OpenShiftConfig.wrap(this.getConfig()).getOpenShiftUrl());
        }
        catch (MalformedURLException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public OpenShiftOperation<T, L, D, R> inNamespace(String namespace) {
        try {
            return (OpenShiftOperation)this.getClass().getConstructor(OkHttpClient.class, OpenShiftConfig.class, String.class, String.class, String.class, Boolean.class, this.getType(), String.class, Boolean.class, Long.TYPE, Map.class, Map.class, Map.class, Map.class, Map.class).newInstance(this.client, this.getConfig(), this.getAPIVersion(), namespace, this.getName(), this.isCascading(), this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields());
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(t);
        }
    }

    @Override
    public OpenShiftConfig getConfig() {
        return OpenShiftConfig.wrap(super.getConfig());
    }

    @Override
    protected Class<? extends Config> getConfigType() {
        return OpenShiftConfig.class;
    }
}

