/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v4_1;

import io.fabric8.kubernetes.api.builder.v4_1.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_1.Nested;
import io.fabric8.kubernetes.api.builder.v4_1.Predicate;
import io.fabric8.kubernetes.api.model.v4_1.ListMeta;
import io.fabric8.kubernetes.api.model.v4_1.ListMetaBuilder;
import io.fabric8.kubernetes.api.model.v4_1.ListMetaFluentImpl;
import io.fabric8.openshift.api.model.v4_1.Role;
import io.fabric8.openshift.api.model.v4_1.RoleBuilder;
import io.fabric8.openshift.api.model.v4_1.RoleFluentImpl;
import io.fabric8.openshift.api.model.v4_1.RoleList;
import io.fabric8.openshift.api.model.v4_1.RoleListFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RoleListFluentImpl<A extends RoleListFluent<A>>
extends BaseFluent<A>
implements RoleListFluent<A> {
    private String apiVersion;
    private List<RoleBuilder> items;
    private String kind;
    private ListMetaBuilder metadata;

    public RoleListFluentImpl() {
    }

    public RoleListFluentImpl(RoleList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A addToItems(int index, Role item) {
        if (this.items == null) {
            this.items = new ArrayList<RoleBuilder>();
        }
        RoleBuilder builder = new RoleBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.items.add(index >= 0 ? index : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(int index, Role item) {
        if (this.items == null) {
            this.items = new ArrayList<RoleBuilder>();
        }
        RoleBuilder builder = new RoleBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(Role ... items) {
        if (this.items == null) {
            this.items = new ArrayList<RoleBuilder>();
        }
        for (Role item : items) {
            RoleBuilder builder = new RoleBuilder(item);
            this._visitables.add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<Role> items) {
        if (this.items == null) {
            this.items = new ArrayList<RoleBuilder>();
        }
        for (Role item : items) {
            RoleBuilder builder = new RoleBuilder(item);
            this._visitables.add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(Role ... items) {
        for (Role item : items) {
            RoleBuilder builder = new RoleBuilder(item);
            this._visitables.remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<Role> items) {
        for (Role item : items) {
            RoleBuilder builder = new RoleBuilder(item);
            this._visitables.remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Role> getItems() {
        return RoleListFluentImpl.build(this.items);
    }

    @Override
    public List<Role> buildItems() {
        return RoleListFluentImpl.build(this.items);
    }

    @Override
    public Role buildItem(int index) {
        return this.items.get(index).build();
    }

    @Override
    public Role buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public Role buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public Role buildMatchingItem(Predicate<RoleBuilder> predicate) {
        for (RoleBuilder item : this.items) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withItems(List<Role> items) {
        if (this.items != null) {
            this._visitables.removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList<RoleBuilder>();
            for (Role item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = new ArrayList<RoleBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withItems(Role ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (Role item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public RoleListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public RoleListFluent.ItemsNested<A> addNewItemLike(Role item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public RoleListFluent.ItemsNested<A> setNewItemLike(int index, Role item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public RoleListFluent.ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public RoleListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public RoleListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public RoleListFluent.ItemsNested<A> editMatchingItem(Predicate<RoleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.apply(this.items.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ListMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ListMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ListMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public A withNewMetadata(String _continue, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, resourceVersion, selfLink));
    }

    @Override
    public RoleListFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public RoleListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public RoleListFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public RoleListFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ListMetaBuilder().build());
    }

    @Override
    public RoleListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RoleListFluentImpl that = (RoleListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null);
    }

    public class MetadataNestedImpl<N>
    extends ListMetaFluentImpl<RoleListFluent.MetadataNested<N>>
    implements RoleListFluent.MetadataNested<N>,
    Nested<N> {
        private final ListMetaBuilder builder;

        MetadataNestedImpl(ListMeta item) {
            this.builder = new ListMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ListMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)RoleListFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class ItemsNestedImpl<N>
    extends RoleFluentImpl<RoleListFluent.ItemsNested<N>>
    implements RoleListFluent.ItemsNested<N>,
    Nested<N> {
        private final RoleBuilder builder;
        private final int index;

        ItemsNestedImpl(int index, Role item) {
            this.index = index;
            this.builder = new RoleBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new RoleBuilder(this);
        }

        @Override
        public N and() {
            return (N)RoleListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

