/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v4_1;

import io.fabric8.kubernetes.api.builder.v4_1.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_1.Nested;
import io.fabric8.openshift.api.model.v4_1.ClusterRoleBinding;
import io.fabric8.openshift.api.model.v4_1.ClusterRoleBindingBuilder;
import io.fabric8.openshift.api.model.v4_1.ClusterRoleBindingFluentImpl;
import io.fabric8.openshift.api.model.v4_1.NamedClusterRoleBinding;
import io.fabric8.openshift.api.model.v4_1.NamedClusterRoleBindingFluent;

public class NamedClusterRoleBindingFluentImpl<A extends NamedClusterRoleBindingFluent<A>>
extends BaseFluent<A>
implements NamedClusterRoleBindingFluent<A> {
    private String name;
    private ClusterRoleBindingBuilder roleBinding;

    public NamedClusterRoleBindingFluentImpl() {
    }

    public NamedClusterRoleBindingFluentImpl(NamedClusterRoleBinding instance) {
        this.withName(instance.getName());
        this.withRoleBinding(instance.getRoleBinding());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    @Deprecated
    public ClusterRoleBinding getRoleBinding() {
        return this.roleBinding != null ? this.roleBinding.build() : null;
    }

    @Override
    public ClusterRoleBinding buildRoleBinding() {
        return this.roleBinding != null ? this.roleBinding.build() : null;
    }

    @Override
    public A withRoleBinding(ClusterRoleBinding roleBinding) {
        this._visitables.remove(this.roleBinding);
        if (roleBinding != null) {
            this.roleBinding = new ClusterRoleBindingBuilder(roleBinding);
            this._visitables.add(this.roleBinding);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRoleBinding() {
        return this.roleBinding != null;
    }

    @Override
    public NamedClusterRoleBindingFluent.RoleBindingNested<A> withNewRoleBinding() {
        return new RoleBindingNestedImpl();
    }

    @Override
    public NamedClusterRoleBindingFluent.RoleBindingNested<A> withNewRoleBindingLike(ClusterRoleBinding item) {
        return new RoleBindingNestedImpl(item);
    }

    @Override
    public NamedClusterRoleBindingFluent.RoleBindingNested<A> editRoleBinding() {
        return this.withNewRoleBindingLike(this.getRoleBinding());
    }

    @Override
    public NamedClusterRoleBindingFluent.RoleBindingNested<A> editOrNewRoleBinding() {
        return this.withNewRoleBindingLike(this.getRoleBinding() != null ? this.getRoleBinding() : new ClusterRoleBindingBuilder().build());
    }

    @Override
    public NamedClusterRoleBindingFluent.RoleBindingNested<A> editOrNewRoleBindingLike(ClusterRoleBinding item) {
        return this.withNewRoleBindingLike(this.getRoleBinding() != null ? this.getRoleBinding() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamedClusterRoleBindingFluentImpl that = (NamedClusterRoleBindingFluentImpl)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.roleBinding != null ? !this.roleBinding.equals(that.roleBinding) : that.roleBinding != null);
    }

    public class RoleBindingNestedImpl<N>
    extends ClusterRoleBindingFluentImpl<NamedClusterRoleBindingFluent.RoleBindingNested<N>>
    implements NamedClusterRoleBindingFluent.RoleBindingNested<N>,
    Nested<N> {
        private final ClusterRoleBindingBuilder builder;

        RoleBindingNestedImpl(ClusterRoleBinding item) {
            this.builder = new ClusterRoleBindingBuilder(this, item);
        }

        RoleBindingNestedImpl() {
            this.builder = new ClusterRoleBindingBuilder(this);
        }

        @Override
        public N and() {
            return (N)NamedClusterRoleBindingFluentImpl.this.withRoleBinding(this.builder.build());
        }

        @Override
        public N endRoleBinding() {
            return this.and();
        }
    }
}

