/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v4_1;

import io.fabric8.kubernetes.api.builder.v4_1.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_1.VisitableBuilder;
import io.fabric8.openshift.api.model.v4_1.ImageList;
import io.fabric8.openshift.api.model.v4_1.ImageListFluent;
import io.fabric8.openshift.api.model.v4_1.ImageListFluentImpl;
import javax.validation.Validator;

public class ImageListBuilder
extends ImageListFluentImpl<ImageListBuilder>
implements VisitableBuilder<ImageList, ImageListBuilder> {
    ImageListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ImageListBuilder() {
        this(true);
    }

    public ImageListBuilder(Boolean validationEnabled) {
        this(new ImageList(), validationEnabled);
    }

    public ImageListBuilder(ImageListFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ImageListBuilder(ImageListFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ImageList(), validationEnabled);
    }

    public ImageListBuilder(ImageListFluent<?> fluent, ImageList instance) {
        this(fluent, instance, true);
    }

    public ImageListBuilder(ImageListFluent<?> fluent, ImageList instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public ImageListBuilder(ImageList instance) {
        this(instance, (Boolean)true);
    }

    public ImageListBuilder(ImageList instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public ImageListBuilder(Validator validator) {
        this(new ImageList(), (Boolean)true);
    }

    public ImageListBuilder(ImageListFluent<?> fluent, ImageList instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ImageListBuilder(ImageList instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public ImageList build() {
        ImageList buildable = new ImageList(this.fluent.getApiVersion(), this.fluent.getItems(), this.fluent.getKind(), this.fluent.getMetadata());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageListBuilder that = (ImageListBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

