/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v4_1;

import io.fabric8.kubernetes.api.builder.v4_1.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_1.VisitableBuilder;
import io.fabric8.openshift.api.model.v4_1.ClusterPolicy;
import io.fabric8.openshift.api.model.v4_1.ClusterPolicyFluent;
import io.fabric8.openshift.api.model.v4_1.ClusterPolicyFluentImpl;
import javax.validation.Validator;

public class ClusterPolicyBuilder
extends ClusterPolicyFluentImpl<ClusterPolicyBuilder>
implements VisitableBuilder<ClusterPolicy, ClusterPolicyBuilder> {
    ClusterPolicyFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ClusterPolicyBuilder() {
        this(true);
    }

    public ClusterPolicyBuilder(Boolean validationEnabled) {
        this(new ClusterPolicy(), validationEnabled);
    }

    public ClusterPolicyBuilder(ClusterPolicyFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ClusterPolicyBuilder(ClusterPolicyFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ClusterPolicy(), validationEnabled);
    }

    public ClusterPolicyBuilder(ClusterPolicyFluent<?> fluent, ClusterPolicy instance) {
        this(fluent, instance, true);
    }

    public ClusterPolicyBuilder(ClusterPolicyFluent<?> fluent, ClusterPolicy instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withLastModified(instance.getLastModified());
        fluent.withMetadata(instance.getMetadata());
        fluent.withRoles(instance.getRoles());
        this.validationEnabled = validationEnabled;
    }

    public ClusterPolicyBuilder(ClusterPolicy instance) {
        this(instance, (Boolean)true);
    }

    public ClusterPolicyBuilder(ClusterPolicy instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withLastModified(instance.getLastModified());
        this.withMetadata(instance.getMetadata());
        this.withRoles(instance.getRoles());
        this.validationEnabled = validationEnabled;
    }

    public ClusterPolicyBuilder(Validator validator) {
        this(new ClusterPolicy(), (Boolean)true);
    }

    public ClusterPolicyBuilder(ClusterPolicyFluent<?> fluent, ClusterPolicy instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withLastModified(instance.getLastModified());
        fluent.withMetadata(instance.getMetadata());
        fluent.withRoles(instance.getRoles());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ClusterPolicyBuilder(ClusterPolicy instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withLastModified(instance.getLastModified());
        this.withMetadata(instance.getMetadata());
        this.withRoles(instance.getRoles());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public ClusterPolicy build() {
        ClusterPolicy buildable = new ClusterPolicy(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getLastModified(), this.fluent.getMetadata(), this.fluent.getRoles());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterPolicyBuilder that = (ClusterPolicyBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

