/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v4_1;

import io.fabric8.kubernetes.api.builder.v4_1.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_1.VisitableBuilder;
import io.fabric8.openshift.api.model.v4_1.BuildSpec;
import io.fabric8.openshift.api.model.v4_1.BuildSpecFluent;
import io.fabric8.openshift.api.model.v4_1.BuildSpecFluentImpl;
import javax.validation.Validator;

public class BuildSpecBuilder
extends BuildSpecFluentImpl<BuildSpecBuilder>
implements VisitableBuilder<BuildSpec, BuildSpecBuilder> {
    BuildSpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public BuildSpecBuilder() {
        this(true);
    }

    public BuildSpecBuilder(Boolean validationEnabled) {
        this(new BuildSpec(), validationEnabled);
    }

    public BuildSpecBuilder(BuildSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public BuildSpecBuilder(BuildSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new BuildSpec(), validationEnabled);
    }

    public BuildSpecBuilder(BuildSpecFluent<?> fluent, BuildSpec instance) {
        this(fluent, instance, true);
    }

    public BuildSpecBuilder(BuildSpecFluent<?> fluent, BuildSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCompletionDeadlineSeconds(instance.getCompletionDeadlineSeconds());
        fluent.withNodeSelector(instance.getNodeSelector());
        fluent.withOutput(instance.getOutput());
        fluent.withPostCommit(instance.getPostCommit());
        fluent.withResources(instance.getResources());
        fluent.withRevision(instance.getRevision());
        fluent.withServiceAccount(instance.getServiceAccount());
        fluent.withSource(instance.getSource());
        fluent.withStrategy(instance.getStrategy());
        fluent.withTriggeredBy(instance.getTriggeredBy());
        this.validationEnabled = validationEnabled;
    }

    public BuildSpecBuilder(BuildSpec instance) {
        this(instance, (Boolean)true);
    }

    public BuildSpecBuilder(BuildSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCompletionDeadlineSeconds(instance.getCompletionDeadlineSeconds());
        this.withNodeSelector(instance.getNodeSelector());
        this.withOutput(instance.getOutput());
        this.withPostCommit(instance.getPostCommit());
        this.withResources(instance.getResources());
        this.withRevision(instance.getRevision());
        this.withServiceAccount(instance.getServiceAccount());
        this.withSource(instance.getSource());
        this.withStrategy(instance.getStrategy());
        this.withTriggeredBy(instance.getTriggeredBy());
        this.validationEnabled = validationEnabled;
    }

    public BuildSpecBuilder(Validator validator) {
        this(new BuildSpec(), (Boolean)true);
    }

    public BuildSpecBuilder(BuildSpecFluent<?> fluent, BuildSpec instance, Validator validator) {
        this.fluent = fluent;
        fluent.withCompletionDeadlineSeconds(instance.getCompletionDeadlineSeconds());
        fluent.withNodeSelector(instance.getNodeSelector());
        fluent.withOutput(instance.getOutput());
        fluent.withPostCommit(instance.getPostCommit());
        fluent.withResources(instance.getResources());
        fluent.withRevision(instance.getRevision());
        fluent.withServiceAccount(instance.getServiceAccount());
        fluent.withSource(instance.getSource());
        fluent.withStrategy(instance.getStrategy());
        fluent.withTriggeredBy(instance.getTriggeredBy());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public BuildSpecBuilder(BuildSpec instance, Validator validator) {
        this.fluent = this;
        this.withCompletionDeadlineSeconds(instance.getCompletionDeadlineSeconds());
        this.withNodeSelector(instance.getNodeSelector());
        this.withOutput(instance.getOutput());
        this.withPostCommit(instance.getPostCommit());
        this.withResources(instance.getResources());
        this.withRevision(instance.getRevision());
        this.withServiceAccount(instance.getServiceAccount());
        this.withSource(instance.getSource());
        this.withStrategy(instance.getStrategy());
        this.withTriggeredBy(instance.getTriggeredBy());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public BuildSpec build() {
        BuildSpec buildable = new BuildSpec(this.fluent.getCompletionDeadlineSeconds(), this.fluent.getNodeSelector(), this.fluent.getOutput(), this.fluent.getPostCommit(), this.fluent.getResources(), this.fluent.getRevision(), this.fluent.getServiceAccount(), this.fluent.getSource(), this.fluent.getStrategy(), this.fluent.getTriggeredBy());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildSpecBuilder that = (BuildSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

