/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_1.dsl.internal;

import io.fabric8.kubernetes.api.model.v4_1.DoneableService;
import io.fabric8.kubernetes.api.model.v4_1.Service;
import io.fabric8.kubernetes.api.model.v4_1.ServiceBuilder;
import io.fabric8.kubernetes.api.model.v4_1.ServiceFluent;
import io.fabric8.kubernetes.api.model.v4_1.ServiceList;
import io.fabric8.kubernetes.clnt.v4_1.Config;
import io.fabric8.kubernetes.clnt.v4_1.DefaultKubernetesClient;
import io.fabric8.kubernetes.clnt.v4_1.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v4_1.ServiceToURLProvider;
import io.fabric8.kubernetes.clnt.v4_1.dsl.ServiceResource;
import io.fabric8.kubernetes.clnt.v4_1.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.clnt.v4_1.dsl.internal.EndpointsOperationsImpl;
import io.fabric8.kubernetes.clnt.v4_1.utils.URLUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;

public class ServiceOperationsImpl
extends HasMetadataOperation<Service, ServiceList, DoneableService, ServiceResource<Service, DoneableService>>
implements ServiceResource<Service, DoneableService> {
    public ServiceOperationsImpl(OkHttpClient client, Config config, String namespace) {
        this(client, config, null, namespace, null, true, null, null, false, -1L, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>());
    }

    public ServiceOperationsImpl(OkHttpClient client, Config config, String apiVersion, String namespace, String name, Boolean cascading, Service item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields) {
        super(client, config, null, apiVersion, "services", namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields);
    }

    @Override
    public Service replace(Service item) {
        try {
            Service old = (Service)this.getMandatory();
            return super.replace(((ServiceBuilder)((ServiceFluent.SpecNested)new ServiceBuilder(item).editSpec().withClusterIP(old.getSpec().getClusterIP())).endSpec()).build());
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("replace"), (Throwable)e);
        }
    }

    @Override
    public Service patch(Service item) {
        try {
            Service old = (Service)this.getMandatory();
            return super.patch(((ServiceBuilder)((ServiceFluent.SpecNested)new ServiceBuilder(item).editSpec().withClusterIP(old.getSpec().getClusterIP())).endSpec()).build());
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("patch"), (Throwable)e);
        }
    }

    @Override
    public Service waitUntilReady(long amount, TimeUnit timeUnit) throws InterruptedException {
        long started = System.currentTimeMillis();
        super.waitUntilReady(amount, timeUnit);
        long alreadySpent = System.currentTimeMillis() - started;
        long remaining = Math.max(10000L, timeUnit.toMillis(amount) - alreadySpent);
        EndpointsOperationsImpl endpointsOperation = new EndpointsOperationsImpl(this.client, this.config, this.apiVersion, this.getNamespace(), this.getName(), this.isCascading(), null, null, this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields());
        endpointsOperation.waitUntilReady(remaining, TimeUnit.MILLISECONDS);
        return (Service)this.get();
    }

    @Override
    public String getURL(String portName) {
        String clusterIP = ((Service)this.getMandatory()).getSpec().getClusterIP();
        if ("None".equals(clusterIP)) {
            throw new IllegalStateException("Service: " + ((Service)this.getMandatory()).getMetadata().getName() + " in namespace " + this.namespace + " is head-less. Search for endpoints instead");
        }
        return this.getUrlHelper(portName);
    }

    private String getUrlHelper(String portName) {
        ServiceLoader<ServiceToURLProvider> urlProvider = ServiceLoader.load(ServiceToURLProvider.class, Thread.currentThread().getContextClassLoader());
        Iterator<ServiceToURLProvider> iterator = urlProvider.iterator();
        ArrayList<ServiceToURLProvider> servicesList = new ArrayList<ServiceToURLProvider>();
        while (iterator.hasNext()) {
            servicesList.add(iterator.next());
        }
        Collections.sort(servicesList, new ServiceToUrlSortComparator());
        for (ServiceToURLProvider serviceToURLProvider : servicesList) {
            String url = serviceToURLProvider.getURL((Service)this.getMandatory(), portName, this.namespace, new DefaultKubernetesClient(this.client, this.getConfig()));
            if (url == null || !URLUtils.isValidURL(url)) continue;
            return url;
        }
        return null;
    }

    public class ServiceToUrlSortComparator
    implements Comparator<ServiceToURLProvider> {
        @Override
        public int compare(ServiceToURLProvider first, ServiceToURLProvider second) {
            return first.getPriority() - second.getPriority();
        }
    }
}

